// 以下为车辆相关常量类型的编码
export const VEHICLE_CONSTANT_VEHICLE_BRAND = 1; // "车辆品牌"
export const VEHICLE_CONSTANT_VEHICLE_USE = 2; // "车辆用途"
export const INSURANCE_COMPANY = 3; // "保险公司"


export const VEHICLE_CONSTANT_BRAND_CODE_UNKOWN = 0; // 车辆品牌-未知
export const VEHICLE_CONSTANT_USE_TYPE_UNKOWN = 0; // "车辆用途" - 未知
export const VEHICLE_CONSTANT_INSURANCE_COMPANY_UNKOWN = 0; // "车辆用途" - 未知

export const VEHICLE_CONSTANT_STATUS_DISCARD = 3; // 车辆状态 - 废弃
export const VEHICLE_CONSTANT_STATUS_NORMAL = 1; // 车辆状态 - 废弃

export const BOOK_RECORD_STATUS_APPLY = 1; // 预定记录状态 - 申请中
export const BOOK_RECORD_STATUS_PROVED = 2; // 预定记录状态 - 已通过
export const BOOK_RECORD_STATUS_LIFT = 7; // 预定记录状态 - 已提车


const baseInfo = {
  state: {
    regions: {},
    regionAndCode: {},
    vehicleConstants: {},
    vehicleStatusAndCode: {
      1: {
        code: 1,
        val: '正常运行'
      },
      2: {
        code: 2,
        val: '维修'
      },
      3: {
        code: 3,
        val: '报废'
      }
    },
    codeAndBranchCompany: {},
    bookRecordStatusAndCode: {
      1: {
        code: 1,
        val: '申请中'
      },
      2: {
        code: 2,
        val: '已通过'
      },
      3: {
        code: 3,
        val: '已归还'
      },
      4: {
        code: 3,
        val: '拒绝'
      },
      5: {
        code: 5,
        val: '逾期归还'
      },
      6: {
        code: 6,
        val: '取消预订'
      },
      7: {
        code: 7,
        val: '已提车'
      }
    }
  },
  mutations: {
    ADD_SON_REGION: (state, sonsAndcode) => {
      state.regions[sonsAndcode.code] = sonsAndcode.sons;
    },
    ADD_REGION: (state, region) => {
      state.regionAndCode[region.id] = region;
    },
    ADD_CONSTANT_DATA: (state, constantMapAndType) => {
      state.vehicleConstants[constantMapAndType.type] = constantMapAndType.constantMap;
    },
    REMOVE_CONSTANT_DATA: (state, type) => {
      state.vehicleConstants[type] = null;
    },
    CAHCE_ALL_COMPANY: (state, companyAndCode) => {
      state.codeAndBranchCompany = companyAndCode;
    }
  },

  actions: {
    // 加入子地区
    cacheSonRegions({
                      commit
                    }, sonsAndcode) {
      commit('ADD_SON_REGION', sonsAndcode);
    },
    // 加入地区
    cacheRegion({
                  commit
                }, datas) {
      for (let index in datas) {
        commit('ADD_REGION', datas[index]);
      }
    },
    cacheConstant({
                    commit
                  }, constantMapAndType) {
      commit('ADD_CONSTANT_DATA', constantMapAndType);
    },
    clearConstant({
                    commit
                  }, type) {
      commit('REMOVE_CONSTANT_DATA', type);
    },
    cacheCompany({
                   commit
                 }, companyAndCode) {
      commit('CAHCE_ALL_COMPANY', companyAndCode);
    }
  }
}


export default baseInfo;
