const getters = {
  sidebar: state => state.app.sidebar,
  visitedViews: state => state.app.visitedViews,
  token: state => state.user.token,
  avatar: state => state.user.avatar,
  name: state => state.user.name,
  introduction: state => state.user.introduction,
  status: state => state.user.status,
  roles: state => state.user.roles,
  menus: state => state.user.menus,
  elements: state => state.user.elements,
  setting: state => state.user.setting,
  permission_routers: state => state.permission.routers,
  addRouters: state => state.permission.addRouters,
  permissionMenus: state => state.user.permissionMenus,
  sonRegions: state => {
    return code => {
      if (!state.baseInfo.regions || !state.baseInfo.regions.hasOwnProperty(code)) {
        return null;
      }
      return state.baseInfo.regions[code]
    };
  },
  region: state => {
    return code => {
      if (typeof (state.baseInfo.regionAndCode) == 'undefined' || !state.baseInfo.regionAndCode.hasOwnProperty(code)) {
        return null;
      }
      return state.baseInfo.regionAndCode[code]
    };
  },
  vehicleConstants: state => {
    return type => {
      if (!state.baseInfo.vehicleConstants || !state.baseInfo.vehicleConstants.hasOwnProperty(type)) {
        return null;
      }
      return state.baseInfo.vehicleConstants[type]
    };
  },
  vehicleStatus: state => state.baseInfo.vehicleStatusAndCode,
  bookRecordStatus: state => state.baseInfo.bookRecordStatusAndCode,
  getAllCompany: state => state.baseInfo.codeAndBranchCompany
};
export default getters
