import fetch from 'utils/fetch';


export function page(query) {
  return fetch({
    url: '/vehicle/vehicleInfo/bookedRecord',
    method: 'get',
    params: {vehicleBookRecordQueryVoJson: JSON.stringify(query)}
  });
}

export function getObj(id) {
  return fetch({
    url: '/vehicle/vehicleInfo/' + id,
    method: 'get'
  });
}


export function prove(id) {
  return fetch({
    url: '/vehicle/vehicleInfo/book/4employee/prove/' + id,
    method: 'put'
  });
}

export function reject(id) {
  return fetch({
    url: '/vehicle/vehicleInfo/book/4employee/reject/' + id,
    method: 'put'
  });
}

export function unbook(id) {
  return fetch({
    url: '/vehicle/vehicleInfo/unbook/4employee/' + id,
    method: 'delete'
  });
}

export function lift(data) {
  return fetch({
    url: '/vehicle/vehicleInfo/book/4employee/lift',
    method: 'put',
    data: data
  });
}

export function ret(data) {
  return fetch({
    url: '/vehicle/vehicleInfo/book/4employee/ret',
    method: 'put',
    data: data
  });
}
