import store from "../../../store";
import XEUtils from 'xe-utils';//加入常用工具类
import fetch from 'utils/fetch';

export function page(query) {
  return fetch({
    url: '/vehicle/branchCompany/page',
    method: 'get',
    params: query
  });
}

export function getObj(id) {
  return fetch({
    url: '/vehicle/branchCompany/' + id,
    method: 'get'
  });
}


export function addObj(obj) {
  return fetch({
    url: '/vehicle/branchCompany/',
    method: 'post',
    data: obj
  });
}


export function delObj(id) {
  return fetch({
    url: '/vehicle/branchCompany/' + id,
    method: 'delete'
  })
}

export function putObj(obj) {
  return fetch({
    url: '/vehicle/branchCompany',
    method: 'put',
    data: obj
  })
}

export function getAll() {
  return fetch({
    url: '/vehicle/branchCompany',
    method: 'get'
  })
}

/**
 * 获取所有公司信息，并缓存
 * @returns {null|*}
 */
export function getAllCompanyCache(resolve) {
  let codeAndBranchCompany = store.getters.getAllCompany;
  if (XEUtils.isEmpty(codeAndBranchCompany)) { //缓存中不存在
    getAll().then(response => {
      let companyList = response.data;
      if (!companyList || companyList.length === 0) {
        return null;
      }
      codeAndBranchCompany = {};
      for (let index in companyList) {
        codeAndBranchCompany[companyList[index].id] = companyList[index];
      }
      store.dispatch("cacheCompany", codeAndBranchCompany);
      resolve(codeAndBranchCompany);
    });
  } else {
    resolve(codeAndBranchCompany);
  }
}
