import fetch from 'utils/fetch';


export function page(query) {
  return fetch({
    url: '/vehicle/vehicleInfo/app/unauth/getBookRecordInfo',
    method: 'get',
    params: query
  });
}

export function getObj(id, bookEndDate) {
  return fetch({
    url: '/vehicle/vehicleInfo/bookedRecord/' + bookEndDate + '/' + id,
    method: 'get'
  });
}


export function prove(id) {
  return fetch({
    url: '/vehicle/vehicleInfo/book/4employee/prove/' + id,
    method: 'put'
  });
}

export function reject(obj) {
  return fetch({
    url: '/vehicle/vehicleInfo/book/4employee/reject',
    method: 'put',
    data: obj
  });
}

export function unbook(id) {
  return fetch({
    url: '/vehicle/vehicleInfo/unbook/4employee/' + id,
    method: 'delete'
  });
}

export function lift(data) {
  return fetch({
    url: '/vehicle/vehicleInfo/book/4employee/lift',
    method: 'put',
    data: data
  });
}

export function ret(data) {
  return fetch({
    url: '/vehicle/vehicleInfo/book/4employee/ret',
    method: 'put',
    data: data
  });
}

/**
 * 根据id获取一条违章查询记录
 * @param query
 */
export function getOneIllegalRow(id) {
  return fetch({
    url: '/api/order/orderViolation/getOne/' + id,
    method: 'get'
  });
}

/**
 * 保存违章记录
 * @param query
 * {price:图片地址(多个逗号分割)
price:退款总金额
detailId:租车订单id
}
 */
export function saveOrderViolation(params) {
  return fetch({
    url: '/vehicle/departure/app/save',
    method: 'post',
    data: params
  });
}

//出车
export function departureVehicle(param) {
  return fetch({
    url: '/vehicle/active/small/departure',
    method: 'post',
    data: param
  });
}

//收车
export function arrivalVehicle(param) {
  return fetch({
    url: '/vehicle/active/small/arrival',
    method: 'post',
    data: param
  });
}