import fetch from 'utils/fetch';


export function page(query) {
  return fetch({
    url: '/api/im/admin/customer_service/page',
    method: 'get',
    params: query
  });
}

export function findById(id) {
  return fetch({
    url: '/api/im/admin/customer_service/' + id,
    method: 'get'
  });
}

/**
 * 添加或编辑客服
 * @param query
 */
export function add(query) {
  return fetch({
    url: '/api/im/admin/customer_service/add',
    method: 'post',
    data: query
  });
}

/**
 * 修改密码
 * @param telphone
 * @param password
 */
export function updatePassword(telphone, password) {
  return fetch({
    url: '/api/im/admin/customer_service/update_password/' + telphone + '/' + password,
    method: 'put'
  });
}

/**
 * 删除
 * @param id
 * @param imUserId
 */
export function deleteById(id, imUserId) {
  return fetch({
    url: '/api/im/admin/customer_service/delete/' + id + '/' + imUserId,
    method: 'delete'
  });
}
