import fetch from 'utils/fetch';

export function getObj(id) {
  return fetch({
    url: '/vehicle/branchCompany/stock/apply/' + id,
    method: 'get'
  });
}

export function page(param) {
  return fetch({
    url: '/vehicle/branchCompany/stock/apply/page',
    method: 'get',
    params: param
  });
}

export function delObj(id) {
  return fetch({
    url: '/vehicle/branchCompany/stock/apply/' + id,
    method: 'delete'
  });
}

export function buyStock(id) {
  return fetch({
    url: '/vehicle/branchCompany/stock/apply/buy',
    method: 'post',
    params: {
      applyId: id
    }
  });
}

export function cancelApply(id) {
  return fetch({
    url: '/vehicle/branchCompany/stock/apply/cancel',
    method: 'post',
    params: {
      applyId: id
    }
  });
}


