import fetch from 'utils/fetch';

export function page(query) {
  return fetch({
    url: '/api/app/admin/config/page',
    method: 'get',
    params: query
  });
}
/**
 * 编辑通用设置
 * @param query
 */
export function editGeneral(param) {
  return fetch({
    url: '/api/app/admin/config/' + param.id,
    method: 'put',
    data: param
  });
}

/**
 * 创建通用设置
 */
export function addGeneral(param) {
  return fetch({
    url: '/api/app/admin/config',
    method: 'post',
    data: param
  });
}

/**
 * 删除通用设置
 */
export function delGeneral(id) {
  return fetch({
    url: '/api/app/admin/config/' + id,
    method: 'delete'
  });
}

