// 以下为车辆相关常量类型的编码
export const VEHICLE_CONSTANT_VEHICLE_BRAND = 1; // "车辆品牌"
export const VEHICLE_CONSTANT_VEHICLE_USE = 2; // "车辆用途"
export const INSURANCE_COMPANY = 3; // "保险公司"
export const ZONE = 4; // "片区"


export const VEHICLE_CONSTANT_BRAND_CODE_UNKOWN = 0; // 车辆品牌-未知
export const VEHICLE_CONSTANT_USE_TYPE_UNKOWN = 0; // "车辆用途" - 未知
export const VEHICLE_CONSTANT_INSURANCE_COMPANY_UNKOWN = 0; // "车辆用途" - 未知

export const VEHICLE_CONSTANT_STATUS_DISCARD = 3; // 车辆状态 - 废弃
export const VEHICLE_CONSTANT_STATUS_NORMAL = 1; // 车辆状态 - 废弃

export const BOOK_RECORD_STATUS_APPLY = 1; // 预定记录状态 - 申请中
export const BOOK_RECORD_STATUS_PROVED = 2; // 预定记录状态 - 已通过
export const BOOK_RECORD_STATUS_LIFT = 7; // 预定记录状态 - 已提车


export const ACCOMPANYING_ITEM_AMOUNT_INFINITY = -1; // 随车物品余量 - 不作限制

export const BELONG_TO_TYPE_OWN = 1; // 车辆所属类型 - 自有


import XEUtils from 'xe-utils';// 加入常用工具类
import VXEUtils from 'vxe-utils';// 加入常用工具类


import {
  getAllAccItem
} from 'api/vehicle/accompanyingItem/';

const baseInfo = {
  state: {
    regions: {},
    regionAndCode: {},
    vehicleConstants: {},
    allAccItem: {},
    allAccItemIdAndName: {},
    vehicleWarningMsgType: {
      1: {
        code: 1,
        val: '汽车保养提醒'
      },
      2: {
        code: 2,
        val: '汽车维修提醒'
      },
      3: {
        code: 3,
        val: '自定义'
      }
    },
    accompanyItemTypeAndCode: {
      1: {
        code: 1,
        val: '随车工具'
      },
      2: {
        code: 2,
        val: '随车配备'
      },
      3: {
        code: 3,
        val: '可配物品'
      }
    },
    vehicleStatusAndCode: {
      1: {
        code: 1,
        val: '正常运行'
      },
      2: {
        code: 2,
        val: '维修'
      },
      3: {
        code: 3,
        val: '报废'
      },
      4: {
        code: 4,
        val: '出车'
      },
      5: {
        code: 5,
        val: '保养'
      },
			6: {
			     code: 6,
			     val: '维修中'
			 },
			7: {
					 code: 7,
					val: '保养中'
				}
    },
    codeAndBranchCompany: {},
    bookRecordStatusAndCode: {
      1: {
        code: 1,
        val: '申请中'
      },
      2: {
        code: 2,
        val: '已通过'
      },
      3: {
        code: 3,
        val: '已归还'
      },
      4: {
        code: 3,
        val: '拒绝'
      },
      5: {
        code: 5,
        val: '逾期归还'
      },
      6: {
        code: 6,
        val: '取消预订'
      },
      7: {
        code: 7,
        val: '已提车'
      }
    },
    companyStatusAndCode: {
      1: {
        code: 1,
        val: '筹备中'
      },
      2: {
        code: 2,
        val: '试业中'
      },
      3: {
        code: 3,
        val: '选址中'
      },
      4: {
        code: 4,
        val: '已开业'
      },
      5: {
        code: 5,
        val: '装修中'
      }
    },
    campsiteStatusAndCode: {
      1: {
        code: 1,
        val: '筹备中'
      },
      2: {
        code: 2,
        val: '试业中'
      },
      3: {
        code: 3,
        val: '选址中'
      },
      4: {
        code: 4,
        val: '已开业'
      },
      5: {
        code: 5,
        val: '装修中'
      }
    },
    belong2Type: {
      1: {
        code: 1,
        val: '天德房车有限公司'
      },
      2: {
        code: 2,
        val: '托管'
      },
      3: {
        code: 3,
        val: '租赁'
      }
    }
  },
  mutations: {
    ADD_SON_REGION: (state, sonsAndcode) => {
      state.regions[sonsAndcode.code] = sonsAndcode.sons;
    },
    ADD_REGION: (state, region) => {
      state.regionAndCode[region.id] = region;
    },
    ADD_CONSTANT_DATA: (state, constantMapAndType) => {
      state.vehicleConstants[constantMapAndType.type] = constantMapAndType.constantMap;
    },
    REMOVE_CONSTANT_DATA: (state, type) => {
      state.vehicleConstants[type] = null;
    },
    ALL_COMPANY: (state, companyAndCode) => {
      state.codeAndBranchCompany = companyAndCode;
    },
    ALL_ACC_ITEM: (state, allAccItem) => {
      state.allAccItem = allAccItem;
      if (XEUtils.isEmpty(allAccItem)) {
        return;
      }
      for (let key in allAccItem) {
        for (let index in allAccItem[key]) {
          state.allAccItemIdAndName[allAccItem[key][index].id] = allAccItem[key][index].name;
        }
      }
    }
  },

  actions: {
    // 加入子地区
    cacheSonRegions({
                      commit
                    }, sonsAndcode) {
      commit('ADD_SON_REGION', sonsAndcode);
    },
    // 加入地区
    cacheRegion({
                  commit
                }, datas) {
      for (let index in datas) {
        commit('ADD_REGION', datas[index]);
      }
    },
    cacheConstant({
                    commit
                  }, constantMapAndType) {
      commit('ADD_CONSTANT_DATA', constantMapAndType);
    },
    clearConstant({
                    commit
                  }, type) {
      commit('REMOVE_CONSTANT_DATA', type);
    },
    allCompany({
                   commit
                 }, companyAndCode) {
      commit('ALL_COMPANY', companyAndCode);
    },
    loadAccItem({
                  getters,
                  commit
                }, resolve) {
      // 从后端异步读取，返回promise
      return new Promise((resolve, reject) => {
        getAllAccItem().then(response => {
          let accItemList = response.data;
          if (XEUtils.isEmpty(accItemList)) {
            resolve();
            return;
          }
          let allAccItem = {};
          for (let index in accItemList) {
            let arrayType = allAccItem[accItemList[index].type];
            if (!XEUtils.isArray(allAccItem[accItemList[index].type])) {
              arrayType = [];
            }
            arrayType = [...arrayType, accItemList[index]];
            allAccItem[accItemList[index].type] = arrayType;
          }
          commit('ALL_ACC_ITEM', allAccItem);
          resolve();
        }).catch(error => {
          console.error(error);
          reject(error);
        });
        return;
      });
    }
  }
}


export default baseInfo;
