import fetch from 'utils/fetch';

/**
 * 获取收益总览列表
 * @param query
 */
export function incomList(query) {
  return fetch({
    url: '/api/admin/wallet/admin/page',
    method: 'get',
    params: query
  });
}

/**
 * 获取收益流水列表
 * @param query
 */
export function rewardList(query) {
  return fetch({
    url: '/api/admin/walletdetail/admin/page',
    method: 'get',
    params: query
  });
}

/**
 * 佣金比例查询
 * @param query
 */
export function getrewardSetting(query) {
  return fetch({
    url: '/api/admin/postion/admin/postions',
    method: 'get',
    params: query
  });
}

/**
 * 佣金比例设置
 * @param query
 */
export function rewardSetting(data) {
  return fetch({
    url: '/api/admin/postion/admin',
    method: 'put',
    data: data
  });
}

/**
 * 获取收益流水列表
 * @param query
 */
export function discountList(query) {
  return fetch({
    url: '/api/admin/walletcath/admin/page',
    method: 'get',
    params: query
  });
}

/**
 * 列表审核
 * @param query
 */
export function editObj(obj) {
  return fetch({
    url: '/api/admin/walletcath/admin/verifyCath',
    method: 'post',
    params: obj
  });
}

// 禁止||允许提现
export function forbidden(query) {
  return fetch({
    url: '/api/admin/wallet/admin/forbidden',
    method: 'put',
    params: query
  });
}

// 佣金记录
export function recordList(params) {
  return fetch({
    url: 'api/admin/sellingwater/admin/page',
    method: 'post',
    data: params
  });
}
