import fetch from 'utils/fetch';

/**
 * 获取消息列表
 * @param query
 */
export function page(query) {
  return fetch({
    url: '/api/im/msg/bg/app/unauth/list',
    method: 'post',
    data: query
  });
}

/**
 * 获取更新
 * @param query
 */
export function updateMsg(params) {
  return fetch({
    url: '/api/im/msg/bg/app/unauth/update',
    method: 'post',
    data: params
  });
}

/**
 * 删除消息
 */
export function delMsg(query) {
  return fetch({
    url: '/api/im/msg/bg/app/unauth/delete',
    method: 'get',
    params: query
  });
}

/**
 * 获取问答列表
 */
export function geImQuestionList(query) {
  return fetch({
    url: '/api/im/imQuestion/list',
    method: 'get',
    params: query
  });
}

/**
 * 更新问答
 * @param query
 */
export function updateImQuestion(params) {
  return fetch({
    url: '/api/im/imQuestion/bg/app/unauth/update',
    method: 'post',
    data: params
  });
}


/**
 * 删除消息
 */
export function delQuestion(query) {
  return fetch({
    url: '/api/im/imQuestion/bg/app/unauth/delete',
    method: 'get',
    params: query
  });
}



