import store from "../../../store";
import XEUtils from 'xe-utils';//加入常用工具类
import fetch from 'utils/fetch';

export function pageOld(query) {
  return fetch({
    url: '/vehicle/branchCompany/page',
    method: 'get',
    params: query
  });
}

/**
 * 分公司列表
 * @param query
 */
export function page(query) {
  return fetch({
    url: '/vehicle/company/base/list',
    method: 'get',
    params: query
  });
}

/**
 * 设置基础信息
 * @param query
 */
export function updCompany(query) {
  return fetch({
    url: '/vehicle/company/base/updCompany',
    method: 'post',
    data: query
  });
}

/**
 * 设置股权信息
 * @param query
 */
export function updStockInfo(query) {
  return fetch({
    url: '/vehicle/company/base/updStockInfo',
    method: 'post',
    data: query
  });
}

/**
 * 设置详情
 * @param query
 */
export function updCompanyDetail(query) {
  return fetch({
    url: '/vehicle/company/base/updCompanyDetail',
    method: 'post',
    data: query
  });
}

/**
 * 删除
 * @param query
 */
export function deleteOne(params) {
  return fetch({
    url: '/vehicle/company/base/del',
    method: 'post',
    data: params
  });
}

/**
 * 获取详情
 * @param query
 */
export function getCompanyDetail(query) {
  return fetch({
    url: '/vehicle/company/base/getCompanyDetail',
    method: 'get',
    params: query
  });
}

/**
 * 添加分公司
 * @param query
 */
export function addCompany(query) {
  return fetch({
    url: '/vehicle/company/base/addCompany',
    method: 'post',
    data: query
  });
}

/**
 * 获取片区名称
 * @param query
 */
export function zoneName(id) {
  return fetch({
    url: '/vehicle/area/' + id,
    method: 'get'
  });
}


export function allPage(query) {
  return fetch({
    url: '/vehicle/branchCompany/app/unauth/companys',
    method: 'post',
    data: query
  });
}

export function getObj(id) {
  return fetch({
    url: '/vehicle/branchCompany/' + id,
    method: 'get'
  });
}


export function addObj(obj) {
  console.log(obj);
  return fetch({
    url: '/vehicle/branchCompany/',
    method: 'post',
    data: obj
  });
}
// 股权价格
export function getAllStockPrice() {
  return fetch({
    url: '/vehicle/branchCompany/stock/right/app/unauth/stock_right_price',
    method: 'get'
  });
}

// 我要参与-众筹
export function stockApply(obj) {
  return fetch({
    url: '/vehicle/branchCompany/stock/right/app/unauth/apply',
    method: 'post',
    data: obj
  });
}
// 股权列表
export function stockSearchPage(query) {
  return fetch({
    url: '/vehicle/branchCompany/stock/right/app/unauth/webchat_office/stockrights',
    method: 'post',
    data: query
  });
}

// 修改订单还车公司
export function updateEndCompany(params) {
  return fetch({
    url: '/api/order/baseOrder/updateEndCompany',
    method: 'post',
    data: params
  });
}
// 修改预定订单还车公司
export function updateById(params) {
  return fetch({
    url: '/vehicle/vehicleInfo/bookRecord/updateById',
    method: 'post',
    data: params
  });
}
export function delObj(id) {
  return fetch({
    url: '/vehicle/branchCompany/' + id,
    method: 'delete'
  })
}

export function putObj(obj) {
  return fetch({
    url: '/vehicle/branchCompany',
    method: 'put',
    data: obj
  })
}

export function getAll() {
  return fetch({
    url: '/vehicle/branchCompany',
    method: 'get'
  })
}

export function getDetail(id) {
  return fetch({
    url: '/vehicle/company_base/app/unauth/detail/'+id,
    method: 'get'
  })
}

/**
 * 获取所有公司信息
 * @returns {null|*}
 */
export function getAllCompany(resolve) {
    getAll().then(response => {
      let companyList = response.data;
      if (!companyList || companyList.length === 0) {
        return null;
      }
      let codeAndBranchCompany = {};
      for (let index in companyList) {
        codeAndBranchCompany[companyList[index].id] = companyList[index];
      }
      resolve(codeAndBranchCompany);
    });
}

