import fetch from 'utils/fetch';

/**
 * 获取列表
 * @param query
 */
export function getPushList(query) {
  return fetch({
    url: '/api/universal/jpush/list',
    method: 'Get',
    params: query
  });
}

/**
 * 系统发送类型
 * @param query
 */
export function getSendTypeList() {
  return fetch({
    url: '/api/universal/jpush/sendTpyes',
    method: 'Get',
  });
}


/**
 * 跳转页面类型
 * @param query
 */
export function getJumpTypeList() {
  return fetch({
    url: '/api/universal/jpush/jumpTpyes',
    method: 'Get',
  });
}
/**
 * 获取弹窗管理列表某一条数据
 * @param query
 */
export function getObj(id) {
  return fetch({
    url: '/api/universal/jpush/getOne/'+id,
    method: 'Get'
  })
}

/**
 * 弹窗管理--添加
 * @param query
 */
export function addObj(obj) {
    return fetch({
      url: '/api/universal/jpush/addMessagePush',
      method: 'post',
      data: obj
    });
  }

/**
 * 编辑某一条数据,上下架
 * @param query
 */
export function editObj(data) {
  return fetch({
    url: '/api/universal/jpush/udpMessagePush',
    method: 'post',
    data: data
  })
}

/**
 * 删除数据
 * @param query
 */
export function delObj(id) {
  return fetch({
    url: '/api/universal/jpush/del/' + id,
    method: 'delete',
  })
}

/**
 * 立即推送
 * @param query
 */
export function pushStype(query) {
  return fetch({
    url: '/api/universal/jpush/stype',
    method: 'Get',
    params: query
  });
}


