import fetch from 'utils/fetch';

/**
 * 获取列表
 * @param query
 */
export function getModalList(query) {
  return fetch({
    url: '/api/activity/activityPopupManage/manage/findAllByQuery',
    method: 'POST',
    data:query
  });
}

/**
 * 弹窗管理--添加
 * @param query
 */
export function addObj(obj) {
  return fetch({
    url: '/api/activity/activityPopupManage',
    method: 'post',
    data: obj
  });
}

/**
 * 获取弹窗管理列表某一条数据
 * @param query
 */
export function getObj(id) {
  return fetch({
    url: '/api/activity/activityPopupManage/manage/getOne/'+id,
    method: 'Get'
  })
}

/**
 * 编辑某一条数据,上下架
 * @param query
 */
export function editObj(data) {
  return fetch({
    url: '/api/activity/activityPopupManage/'+data.id,
    method: 'put',
    data: data
  })
}

/**
 * 删除数据
 * @param query
 */
export function delObj(id) {
  return fetch({
    url: '/api/activity/activityPopupManage/' + id,
    method: 'delete',
  })
}


