import fetch from 'utils/fetch';

/**
 * 排班列表
 * @param query
 */
export function getVehiclePlanList(query) {
  return fetch({
    url: '/vehicle/vehicleInfo/app/unauth/getVehiclePlanList',
    method: 'get',
    params: query
  });
}
/**
 * 根据订单号获取租车订单详情
 * @param query
 */
export function getVehicleOrderDetail(query) {
  return fetch({
    url: '/api/order/baseOrder/orderDetail',
    method: 'get',
    params: query
  });
}

/**
 * 同意
 * @param query
 */
export function agreeBook(bookRecordId) {
  return fetch({
    url: '/vehicle/vehicleInfo/book/4employee/prove/' + bookRecordId,
    method: 'put'
  });
}

/**
 * 取消
 */
export function cancleBook(obj) {
  return fetch({
    url: '/vehicle/vehicleInfo/unbook/4employee',
    method: 'delete',
    data:obj
  });
}

/**
 * 拒绝
 */
export function rejectBook(obj) {
  return fetch({
    url: '/vehicle/vehicleInfo/book/4employee/reject',
    method: 'put',
    data: obj
  });
}

/**
 * 安排用车
 */
export function bookPlan(query) {
  return fetch({
    url: '/vehicle/vehicleInfo/book/4employee',
    method: 'post',
    data: query
  });
}

/**
 * 排班记录
 */
export function getBookRecord(query) {
  return fetch({
    url: '/vehicle/vehicleInfo/app/unauth/getBookRecord',
    method: 'get',
    params: query
  });
}

/**
 * 首页统计
 */
export function orderStatistics(type) {
  return fetch({
    url: '/api/order/orderStatistics/findAll/' + type,
    method: 'get',
  });
}


/**
 * 
 * 获取保养类型
 */
export function getUpkeepAll() {
  return fetch({
    url: '/vehicle/upkeep/item/all',
    method: 'get',
  });
}

//获取旅游路线
export function getTourList(param) {
  if(param){
    return fetch({
      url: '/api/tour/verfication/getList?'+param,
      method: 'get',
    });
  }else{
    return fetch({
      url: '/api/tour/verfication/getList',
      method: 'get',
    });
  }
}

//获取核销路线id信息
export function getTourInfor(id) {
  return fetch({
    url: '/api/tour/verfication/info/'+id,
    method: 'get',
  });
}
