import fetch from 'utils/fetch';
/**
 * 获活动列表List
 */
export function getActivityList(query) {
  return fetch({
    url: '/api/uccn/admin/summitActivity/list',
    method: 'post',
    data: query
  });
}
/**
 * 根据id获取一条活动数据
 */
export function getOneActivityShop(id) {
  return fetch({
    url: '/api/uccn/admin/summitActivity/' + id,
    method: 'get'
  });
}
/**
 * 编辑活动数据
 * */
export function editActivity(query) {
  return fetch({
    url: '/api/uccn/admin/summitActivity/save',
    method: 'post',
    data: query
  });
}
/**
 * 活动上架、下架
 * */
export function isShowStatus(id, state) {
  return fetch({
    url: '/api/uccn/admin/summitActivity/soldout/' + id + '/' + state,
    method: 'put'
  });
}


/**
 * 活动发布、不发布
 * */
export function isPublishStatus(id, state) {
  return fetch({
    url: '/api/uccn/admin/summitActivity/publish/' + id + '/' + state,
    method: 'put'
  });
}

/**
 * 是否置顶、不发布
 * */
export function isHomePageStatus(id, state) {
  return fetch({
    url: '/api/uccn/admin/summitActivity/home_page/' + id + '/' + state,
    method: 'put'
  });
}
/**
 *删除活动
 */
export function deleteActivityTag(id) {
  return fetch({
    url: '/api/uccn/admin/summitActivity/' + id,
    method: 'delete'
  });
}
