import store from '../../../store';
import rsCode from '../../../utils/rsCode';
import {
  VEHICLE_CONSTANT_VEHICLE_BRAND,
  VEHICLE_CONSTANT_VEHICLE_USE,
  VEHICLE_CONSTANT_BRAND_CODE_UNKOWN,
  INSURANCE_COMPANY,
  ZONE,
  VEHICLE_CONSTANT_INSURANCE_COMPANY_UNKOWN,
  VEHICLE_CONSTANT_USE_TYPE_UNKOWN,
  VEHICLE_CONSTANT_STATUS_NORMAL
} from '../../../store/modules/baseInfo';
import {BASE_API} from "../../../../config/dev.env";
import {
  getToken
} from 'utils/auth';

function loadFromServer(type) {
  if (!type) {
    console.error(' load constant with no type');
    return;
  }
  let headerAuthorization = undefined;
  if (store.getters.token) {
    headerAuthorization = getToken(); // 让每个请求携带token--['Authorization']为自定义key 请根据实际情况自行修改
  }
  // url : baseURL+"",//路径
  let rs = [];
  if(type == 4){
    $.ajax({
      type: 'get',
      // url: process.env.BASE_API + '/vehicle/constant/type/' + type,
      url: process.env.BASE_API + '/vehicle/area/findAll',
      async: false,
      headers: {
        Authorization: headerAuthorization
      },
      dataType: 'json',
      data: {},
      success: function (result) {
        // 返回数据根据结果进行相应的处理
        if (result.code === rsCode.RS_CODE_SUC) {
          result.data.map(function(item){
            rs.push(item);
          })
        } else {
          console.log('请求常量信息出错。');
        }
        return rs;
      },
      error: function () {
        console.log('请求常量信息出错。');
      }
    });
  } else {
    $.ajax({
      type: 'get',
      url: process.env.BASE_API + '/vehicle/constant/type/' + type,
      // url: process.env.BASE_API + '/vehicle/area/findAll',
      async: false,
      headers: {
        Authorization: headerAuthorization
      },
      dataType: 'json',
      data: {},
      success: function (result) {
        // 返回数据根据结果进行相应的处理
        if (result.code === rsCode.RS_CODE_SUC) {
          result.data.map(function(item){
            rs.push(item);
          })
        } else {
          console.log('请求常量信息出错。');
        }
        return rs;
      },
      error: function () {
        console.log('请求常量信息出错。');
      }
    });
  }

  console.log(rs);
  return rs;
}

/**
 * 获取对应类型、编码的常量，相关类型未缓存将缓存/5分钟后过期
 * @param type
 * @param code
 * @returns {null|*}
 */
export function getConstantByTypeAndCode(type, code) {
  if (!type) {
    console.error('empty constant type');
    return null;
  }
  if (!code) {
    console.error('empty constant code');
    return null;
  }
  let constantMap = store.getters.vehicleConstants(type);
  if (!constantMap) {
    let constants = loadFromServer(type);
    if (!constants || constants.length === 0) {
      return null;
    }
    constantMap = {};
    for (let index in constants) {
      constantMap[constants[index].code] = constants[index];
    }
    let constantMapAndType = {type, constantMap};
    store.dispatch("cacheConstant", constantMapAndType);
    setTimeout(() => {
      store.dispatch("clearConstant", type);
    }, 5 * 60 * 1000);
  }
  return constantMap[code];
}

export function getConstantListByType(type) {
  if (!type) {
    console.error('empty constant type');
    return null;
  }
  let constantMap = store.getters.vehicleConstants(type);
  if (constantMap == null || typeof (constantMap) == "undefined") {
    let constants = loadFromServer(type);
    if (!constants || constants.length === 0) {
      return null;
    }
    constantMap = {};
    for (let index in constants) {
      constantMap[constants[index].code] = constants[index];
    }
    let constantMapAndType = {type, constantMap};
    store.dispatch("cacheConstant", constantMapAndType);
    setTimeout(() => {
      store.dispatch("clearConstant", type);
    }, 5 * 60 * 1000);
  }
  return constantMap;
}


export function getConstantListByTypeNew(type) {
  if (!type) {
    console.error('empty constant type');
    return null;
  }
  let constantMap = store.getters.vehicleConstants(type);
  if (constantMap == null || typeof (constantMap) == "undefined") {
    let constants = loadFromServer(type);
    if (!constants || constants.length === 0) {
      return null;
    }
    constantMap = constants;
  }
  return constantMap;
}

/** 保险公司 */
export function getInsuranceCompany(code) {
  if (code == null || typeof (code) == "undefined" || code === VEHICLE_CONSTANT_INSURANCE_COMPANY_UNKOWN) {
    return '未知';
  }
  return getConstantByTypeAndCode(INSURANCE_COMPANY, code).val;
}

export function getAllInsuranceCompany() {
  return getConstantListByType(INSURANCE_COMPANY);
}

/** 片区 */
export function getZone(code) {
  if (code == null || typeof (code) == "undefined" ) {
    return '未知';
  }
  return getConstantByTypeAndCode(ZONE, code).val;
}

export function getAllZone() {
  return getConstantListByTypeNew(ZONE);
}
