module.exports = {
    head: {
        title: '欣新房车—房车·让生活更美好-房车销售丨房车租赁丨房车旅游丨房车托管',
        meta: [
          { charset: 'utf-8' },
          { name: 'viewport', content: 'width=device-width, initial-scale=1' },
          {name:'keywords', 'content': '欣新房车，房车旅游，房车，房车租赁，房车销售，房车价格，房车之家，房车经济，房车高峰论坛' },
          { hid: 'description', name: 'description', content: '欣新房车是一家专业从事房车销售，房车租赁，房车旅游，房车托管及房车产业配套与服务的免费异地取车异地还车已在全国各地举办多届房车经济峰会的集团股份公司' }
        ],
        link: [
          { rel: 'icon', type: 'image/x-icon', href: '/favicon.ico' },
          { rel: 'stylesheet', href: 'https://fonts.googleapis.com/css?family=Roboto:300,400,500,700,400italic' }
        ],
        script: [
          { src: 'https://dev.dfangche.com/h5/appHtml/js/util.js' }
        ],
    },
    css: [
      '~/assets/main.css',
      'swiper/dist/css/swiper.min.css'
    ],

    loading: '~/components/loading.vue',

    plugins: [
      { src: '~plugins/muse-ui.js', ssr: true },
      { src: '~plugins/util.js', ssr: false }
    ],
    build: {

        extend(config, { isDev, isClient }) {
            if (isDev && isClient) {
                config.module.rules.push({
                    enforce: 'pre',
                    test: /\.(js|vue)$/,
                    loader: 'eslint-loader',
                    exclude: /(node_modules)/
                })
            }
        }
    },
    render: {
        bundleRenderer: {
            cache: require('lru-cache')({
                max: 1000,
                maxAge: 1000 * 60 * 15
            }),
            shouldPreload: (file, type) => {
                return ['script', 'style', 'font'].includes(type)
            }
        }
    },
    env: {
      host:"https://dev.dfangche.com"
    },
    generate: {
      routes: [
      ]
    }
}
