import Vue from 'vue'
import Router from 'vue-router'

Vue.use(Router)

const _916d4edc = () => import('..\\pages\\vehicle.vue' /* webpackChunkName: "pages_vehicle" */).then(m => m.default || m)
const _55fc1c46 = () => import('..\\pages\\news.vue' /* webpackChunkName: "pages_news" */).then(m => m.default || m)
const _96254626 = () => import('..\\pages\\demo.vue' /* webpackChunkName: "pages_demo" */).then(m => m.default || m)
const _0e939319 = () => import('..\\pages\\activity.vue' /* webpackChunkName: "pages_activity" */).then(m => m.default || m)
const _1b677f5a = () => import('..\\pages\\aboutXx.vue' /* webpackChunkName: "pages_aboutXx" */).then(m => m.default || m)
const _1b4d0cd2 = () => import('..\\pages\\campsite.vue' /* webpackChunkName: "pages_campsite" */).then(m => m.default || m)
const _51cf86e2 = () => import('..\\pages\\tour.vue' /* webpackChunkName: "pages_tour" */).then(m => m.default || m)
const _5df21ee8 = () => import('..\\pages\\demoList\\demoList.vue' /* webpackChunkName: "pages_demoList_demoList" */).then(m => m.default || m)
const _802b9bc2 = () => import('..\\pages\\demoList\\_id.vue' /* webpackChunkName: "pages_demoList__id" */).then(m => m.default || m)
const _e86eea90 = () => import('..\\pages\\index.vue' /* webpackChunkName: "pages_index" */).then(m => m.default || m)



if (process.client) {
  window.history.scrollRestoration = 'manual'
}
const scrollBehavior = function (to, from, savedPosition) {
  // if the returned position is falsy or an empty object,
  // will retain current scroll position.
  let position = false

  // if no children detected
  if (to.matched.length < 2) {
    // scroll to the top of the page
    position = { x: 0, y: 0 }
  } else if (to.matched.some((r) => r.components.default.options.scrollToTop)) {
    // if one of the children has scrollToTop option set to true
    position = { x: 0, y: 0 }
  }

  // savedPosition is only available for popstate navigations (back button)
  if (savedPosition) {
    position = savedPosition
  }

  return new Promise(resolve => {
    // wait for the out transition to complete (if necessary)
    window.$nuxt.$once('triggerScroll', () => {
      // coords will be used if no selector is provided,
      // or if the selector didn't match any element.
      if (to.hash) {
        let hash = to.hash
        // CSS.escape() is not supported with IE and Edge.
        if (typeof window.CSS !== 'undefined' && typeof window.CSS.escape !== 'undefined') {
          hash = '#' + window.CSS.escape(hash.substr(1))
        }
        try {
          if (document.querySelector(hash)) {
            // scroll to anchor by returning the selector
            position = { selector: hash }
          }
        } catch (e) {
          console.warn('Failed to save scroll position. Please add CSS.escape() polyfill (https://github.com/mathiasbynens/CSS.escape).')
        }
      }
      resolve(position)
    })
  })
}


export function createRouter () {
  return new Router({
    mode: 'history',
    base: '/',
    linkActiveClass: 'nuxt-link-active',
    linkExactActiveClass: 'nuxt-link-exact-active',
    scrollBehavior,
    routes: [
		{
			path: "/vehicle",
			component: _916d4edc,
			name: "vehicle"
		},
		{
			path: "/news",
			component: _55fc1c46,
			name: "news"
		},
		{
			path: "/demo",
			component: _96254626,
			name: "demo"
		},
		{
			path: "/activity",
			component: _0e939319,
			name: "activity"
		},
		{
			path: "/aboutXx",
			component: _1b677f5a,
			name: "aboutXx"
		},
		{
			path: "/campsite",
			component: _1b4d0cd2,
			name: "campsite"
		},
		{
			path: "/tour",
			component: _51cf86e2,
			name: "tour"
		},
		{
			path: "/demoList/demoList",
			component: _5df21ee8,
			name: "demoList-demoList"
		},
		{
			path: "/demoList/:id?",
			component: _802b9bc2,
			name: "demoList-id"
		},
		{
			path: "/",
			component: _e86eea90,
			name: "index"
		}
    ],
    
    
    fallback: false
  })
}
