const env = require('./env')
//const routerPath = '/rvwebsite/';//'/rvwebsite/'
module.exports = {
    head: {
        title: '欣新房车—房车·让生活更美好-房车销售丨房车租赁丨房车旅游丨房车托管',
        meta: [
          { charset: 'utf-8' },
          { name: 'viewport', content: 'width=device-width, initial-scale=1' },
          { hid: 'keywords', name:'keywords', 'content': '欣新房车，房车旅游，房车，房车租赁，房车销售，房车价格，房车之家，房车经济，房车高峰论坛' },
          { hid: 'description', name: 'description', content: '欣新房车是一家专业从事房车销售，房车租赁，房车旅游，房车托管及房车产业配套与服务的免费异地取车异地还车已在全国各地举办多届房车经济峰会的集团股份公司' }
        ],
        link: [
          // { rel: 'icon', type: 'image/x-icon', href: 'https://mgmt.dfangche.com/xxfccn/image/1/app/5d9c62b7412efd926f70e0ed5efb19a.png' },
          // { rel: 'stylesheet', href: 'https://fonts.googleapis.com/css?family=Roboto:300,400,500,700,400italic' },
          // { rel: 'stylesheet', href: 'https://mgmt.dfangche.com/xxfccn/css/pc/main.css' },
          // { rel: 'stylesheet', href: 'https://mgmt.dfangche.com/xxfccn/css/pc/menu.css' },
          // { rel: 'stylesheet', href: 'https://mgmt.dfangche.com/xxfccn/css/pc/footer.css' },
          // { rel: 'stylesheet', href: 'https://mgmt.dfangche.com/xxfccn/css/pc/index.css' },
          // { rel: 'stylesheet', href: 'https://mgmt.dfangche.com/xxfccn/css/pc/iconfont.css' },
          // { rel: 'stylesheet', href: 'https://mgmt.dfangche.com/xxfccn/css/pc/goTop.css' },
          // { rel: 'stylesheet', href: 'https://mgmt.dfangche.com/xxfccn/css/pc/swiper.min.css' },
          // { rel: 'stylesheet', href: 'https://www.xxfangche.com/xxfccn/css/pc/el/index.css' }
          { rel: 'icon', type: 'image/x-icon', href: 'https://mgmt.dfangche.com/xxfccn/image/1/app/5d9c62b7412efd926f70e0ed5efb19a.png' },
          { rel: 'stylesheet', href: 'https://fonts.googleapis.com/css?family=Roboto:300,400,500,700,400italic' },
          { rel: 'stylesheet', href: 'http://xxtest.upyuns.com/xxfccn/css/pc/main.css' },
          { rel: 'stylesheet', href: 'http://xxtest.upyuns.com/xxfccn/css/pc/menu.css' },
          { rel: 'stylesheet', href: 'http://xxtest.upyuns.com/xxfccn/css/pc/footer.css' },
          { rel: 'stylesheet', href: 'http://xxtest.upyuns.com/xxfccn/css/pc/index.css' },
          { rel: 'stylesheet', href: 'http://xxtest.upyuns.com/xxfccn/css/pc/iconfont.css' },
          { rel: 'stylesheet', href: 'http://xxtest.upyuns.com/xxfccn/css/pc/goTop.css' },
          { rel: 'stylesheet', href: 'http://xxtest.upyuns.com/xxfccn/css/pc/swiper.min.css' },
          { rel: 'stylesheet', href: 'http://xxtest.upyuns.com/xxfccn/css/pc/el/index.css' }
        ],
       // http://xxtest.upyuns.com
       //https://mgmt.dfangche.com/xxfccn
        script: [
          { src: 'https://dev.dfangche.com/h5/appHtml/js/util.js' },
        ],
    },
    // css: ['~/assets/index.css','~/assets/menu.css','~/assets/main.css','~/assets/font/iconfont.css','~/assets/footer.css'],

    loading: '~/components/loading.vue',
    plugins: [
      { src: '~plugins/muse-ui.js', ssr: true },
      { src: '~plugins/filters.js', srr: false },
      { src: '~/plugins/elementUI.js', srr: false },
      { src: '~/plugins/baidu.js', srr: true },
      { src: '~/plugins/viewer.js', srr: true },
      { src: '~/plugins/vueSeamlessScroll.js', ssr: false },
    ],
    build: {
        extend(config, { isDev, isClient }) {
            if (isDev && isClient) {
                config.module.rules.push({
                    enforce: 'pre',
                    test: /\.(js|vue)$/,
                    loader: 'eslint-loader',
                    exclude: /(node_modules)/
                })
            }
        },
        //,publicPath: '/rvwebsite/'
        vendor: ['element-ui']
    },
    render: {
        bundleRenderer: {
            cache: require('lru-cache')({
                max: 1000,
                maxAge: 1000 * 60 * 15
            }),
            shouldPreload: (file, type) => {
                return ['script', 'style', 'font'].includes(type)
            }
        }
    },
    env: {
      host:env[process.env.MODE].ENV_API
    },
    generate: {
      routes: [
      ]
    },
    router: {
      base: env[process.env.MODE].ROUTER_PATH,
    }
}
