import Vue from 'vue'
import NuxtLoading from '~/components/loading.vue'


let layouts = {

  "_default": () => import('..\\layouts\\default.vue'  /* webpackChunkName: "layouts_default" */).then(m => m.default || m)

}

let resolvedLayouts = {}

export default {
  head: {"title":"欣新房车—房车·让生活更美好-房车销售丨房车租赁丨房车旅游丨房车托管","meta":[{"charset":"utf-8"},{"name":"viewport","content":"width=device-width, initial-scale=1"},{"hid":"keywords","name":"keywords","content":"欣新房车，房车旅游，房车，房车租赁，房车销售，房车价格，房车之家，房车经济，房车高峰论坛"},{"hid":"description","name":"description","content":"欣新房车是一家专业从事房车销售，房车租赁，房车旅游，房车托管及房车产业配套与服务的免费异地取车异地还车已在全国各地举办多届房车经济峰会的集团股份公司"}],"link":[{"rel":"icon","type":"image\u002Fx-icon","href":"https:\u002F\u002Fmgmt.dfangche.com\u002Fxxfccn\u002Fimage\u002F1\u002Fapp\u002F5d9c62b7412efd926f70e0ed5efb19a.png"},{"rel":"stylesheet","href":"https:\u002F\u002Ffonts.googleapis.com\u002Fcss?family=Roboto:300,400,500,700,400italic"},{"rel":"stylesheet","href":"http:\u002F\u002Fxxtest.upyuns.com\u002Fxxfccn\u002Fcss\u002Fpc\u002Fmain.css"},{"rel":"stylesheet","href":"http:\u002F\u002Fxxtest.upyuns.com\u002Fxxfccn\u002Fcss\u002Fpc\u002Fmenu.css"},{"rel":"stylesheet","href":"http:\u002F\u002Fxxtest.upyuns.com\u002Fxxfccn\u002Fcss\u002Fpc\u002Ffooter.css"},{"rel":"stylesheet","href":"http:\u002F\u002Fxxtest.upyuns.com\u002Fxxfccn\u002Fcss\u002Fpc\u002Findex.css"},{"rel":"stylesheet","href":"http:\u002F\u002Fxxtest.upyuns.com\u002Fxxfccn\u002Fcss\u002Fpc\u002Ficonfont.css"},{"rel":"stylesheet","href":"http:\u002F\u002Fxxtest.upyuns.com\u002Fxxfccn\u002Fcss\u002Fpc\u002FgoTop.css"},{"rel":"stylesheet","href":"http:\u002F\u002Fxxtest.upyuns.com\u002Fxxfccn\u002Fcss\u002Fpc\u002Fswiper.min.css"},{"rel":"stylesheet","href":"http:\u002F\u002Fxxtest.upyuns.com\u002Fxxfccn\u002Fcss\u002Fpc\u002Fel\u002Findex.css"}],"script":[{"src":"https:\u002F\u002Fdev.dfangche.com\u002Fh5\u002FappHtml\u002Fjs\u002Futil.js"}],"style":[]},
  render(h, props) {
    const loadingEl = h('nuxt-loading', { ref: 'loading' })
    const layoutEl = h(this.layout || 'nuxt')
    const templateEl = h('div', {
      domProps: {
        id: '__layout'
      },
      key: this.layoutName
    }, [ layoutEl ])

    const transitionEl = h('transition', {
      props: {
        name: 'layout',
        mode: 'out-in'
      }
    }, [ templateEl ])

    return h('div',{
      domProps: {
        id: '__nuxt'
      }
    }, [
      loadingEl,
      transitionEl
    ])
  },
  data: () => ({
    layout: null,
    layoutName: ''
  }),
  beforeCreate () {
    Vue.util.defineReactive(this, 'nuxt', this.$options.nuxt)
  },
  created () {
    // Add this.$nuxt in child instances
    Vue.prototype.$nuxt = this
    // add to window so we can listen when ready
    if (typeof window !== 'undefined') {
      window.$nuxt = this
    }
    // Add $nuxt.error()
    this.error = this.nuxt.error
  },
  
  mounted () {
    this.$loading = this.$refs.loading
  },
  watch: {
    'nuxt.err': 'errorChanged'
  },
  
  methods: {
    
    errorChanged () {
      if (this.nuxt.err && this.$loading) {
        if (this.$loading.fail) this.$loading.fail()
        if (this.$loading.finish) this.$loading.finish()
      }
    },
    
    setLayout (layout) {
      if (!layout || !resolvedLayouts['_' + layout]) layout = 'default'
      this.layoutName = layout
      let _layout = '_' + layout
      this.layout = resolvedLayouts[_layout]
      return this.layout
    },
    loadLayout (layout) {
      if (!layout || !(layouts['_' + layout] || resolvedLayouts['_' + layout])) layout = 'default'
      let _layout = '_' + layout
      if (resolvedLayouts[_layout]) {
        return Promise.resolve(resolvedLayouts[_layout])
      }
      return layouts[_layout]()
      .then((Component) => {
        resolvedLayouts[_layout] = Component
        delete layouts[_layout]
        return resolvedLayouts[_layout]
      })
      .catch((e) => {
        if (this.$nuxt) {
          return this.$nuxt.error({ statusCode: 500, message: e.message })
        }
      })
    }
  },
  components: {
    NuxtLoading
  }
}

