const env = require('./env')

module.exports = {
  mode: 'spa',
  head: {
    title: '欣新房车—房车·让生活更美好-房车销售丨房车租赁丨房车旅游丨房车托管',
    meta: [
      { charset: 'utf-8' },
      { name: 'viewport', content: 'width=device-width, initial-scale=1, maximum-scale=1, user-scalable=0' },
      { name: 'format-detection', content: 'telephone=no' },
      { name: 'msapplication-tap-highlight', content: 'no' },
      { name: 'apple-mobile-web-app-capable', content: 'yes' },
      {name:'keywords', 'content': '欣新房车，房车旅游，房车，房车租赁，房车销售，房车价格，房车之家，房车经济，房车高峰论坛' },
      { hid: 'description', name: 'description', content: '欣新房车是一家专业从事房车销售，房车租赁，房车旅游，房车托管及房车产业配套与服务的免费异地取车异地还车已在全国各地举办多届房车经济峰会的集团股份公司' }
    ],
    link: [
      { rel: 'icon', type: 'image/x-icon', href: 'https://mgmt.dfangche.com/xxfccn/image/1/app/5d9c62b7412efd926f70e0ed5efb19a.png' },
    ],
    script: [
      { src: 'https://easytuan.gitee.io/node-elm-api/public/flexible.js' },
    ],
  },

  loading: { color: '#3B8070' },

  cache: true,

  build: {
    vendor: ['axios', 'mint-ui', 'js-cookie'],
    extend (config, { isDev, isClient }) {
      if (isDev && isClient) {
        config.module.rules.push({
          enforce: 'pre',
          test: /\.(js|vue)$/,
          loader: 'eslint-loader',
          exclude: /(node_modules)/
        })
      }
    }
  },

  plugins: [
    { src: '~plugins/mint-ui' },
    { src: '~assets/styles/base.scss' },
    { src: '~plugins/filters.js', srr: false },
    { src: '~/plugins/baidu.js', srr: true },
  ],
  env: {
      host:env[process.env.MODE].ENV_API
  },
  router: {
      base: env[process.env.MODE].ROUTER_PATH,
  }

}

