package com.xxrv.video.adapter;

import android.widget.ImageView;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.ruiwenliu.wrapper.util.glide.GlideManager;
import com.rv.component.utils.DateUtils;
import com.xxrv.video.R;
import com.xxrv.video.bean.circle.VideoFile;

/**
 * 短视频选择
 */

public class DiscoveryVideoSelectAdapter extends BaseQuickAdapter<VideoFile, BaseViewHolder> {

    public DiscoveryVideoSelectAdapter() {
        super(R.layout.rv_item_discovery_video_select);
    }

    @Override
    protected void convert(BaseViewHolder helper, VideoFile item) {
        if (item == null) {
            return;
        }
        GlideManager.getInstance(mContext).loadImage(item.getFilePath(), (ImageView) helper.getView(R.id.iv_video_icon));

        helper.setText(R.id.tv_video_date, DateUtils.timestampToString1(item.getCreateTime()));
        helper.setText(R.id.tv_video_duration, item.getFileLength() + "秒");
        helper.setText(R.id.tv_video_size, parserFileSize(item.getFileSize()));

    }


    private String parserFileSize(long size) {
        float temp = size / (float) 1024;
        if (temp < 1024) {
            return (int) temp + "KB";
        }
        temp = temp / 1024;
        if (temp < 1024) {
            return ((int) (temp * 100)) / (float) 100 + "M";
        }
        temp = temp / 1024;
        return ((int) (temp * 100)) / (float) 100 + "G";
    }
}
