package com.rv.version;

import android.content.Context;
import android.support.annotation.NonNull;
import android.view.Gravity;
import android.view.ViewGroup;
import android.widget.Button;

import com.ruiwenliu.wrapper.dialog.BaseDialog;

/**********
 * 升级界面
 */
public class UpdateUnforceDialog extends BaseDialog implements DownListenerManager.DownListener {


    private Button btnKnow;

    public UpdateUnforceDialog(Context context, int themeResId) {
        super(context, themeResId);
        DownListenerManager.getInstance().addDownListener(this);
        setDialogParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT, Gravity.CENTER);
        setCancelable(false);

        btnKnow = findViewById(R.id.btn_know);
        btnKnow.setOnClickListener(v -> dismiss());
    }

    public UpdateUnforceDialog(@NonNull Context context) {
        this(context, 0);
    }

    @Override
    public int getViewLayout() {
        return R.layout.dialog_update_unforce_view;
    }


    @Override
    public void pending() {

    }

    @Override
    public void paused() {

    }

    @Override
    public void progress(int progress) {

    }

    @Override
    public void completed() {
        dismiss();
    }

    @Override
    public void error() {

        setCancelable(true);
    }

    @Override
    public void dismiss() {
        super.dismiss();
        DownListenerManager.getInstance().removeDownListener(this);
    }
}
