package com.rv.share.view;

import android.app.Dialog;
import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;

import com.bumptech.glide.Glide;
import com.ruiwenliu.wrapper.bean.ActBean;
import com.ruiwenliu.wrapper.dialog.BaseDialog;
import com.ruiwenliu.wrapper.util.glide.GlideManager;
import com.ruiwenliu.wrapper.util.glide.GlideOptions;
import com.rv.share.R;
import com.rv.share.utils.TransformationUtils;

public class PromotionDialog extends BaseDialog {

    public PromotionDialog(@NonNull Context context) {
        super(context);
    }

    public PromotionDialog(Context context, int themeResId) {
        super(context, themeResId);
        setDialogParams(ViewGroup.LayoutParams.MATCH_PARENT,ViewGroup.LayoutParams.WRAP_CONTENT, Gravity.CENTER);
    }

    @Override
    public int getViewLayout() {
        return R.layout.dialog_promotion;
    }

    public static class Builder {

        private Context mContext;
        private ImageView imgBg;
        private ImageView imgClose;
        private View.OnClickListener mListener;
        private ActBean.Act act;

        public Builder(Context context, View.OnClickListener listener) {
            mContext = context;
            this.mListener = listener;
        }

        public Builder show() {
            final PromotionDialog dialog = create();
            dialog.show();
            return this;
        }

        public Builder setData(ActBean.Act act) {
            this.act = act;
            return this;
        }

        /**
         * 创建定制的对话框
         */
        public PromotionDialog create() {
            LayoutInflater inflater = (LayoutInflater) mContext.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
            final PromotionDialog dialog = new PromotionDialog(mContext, R.style.DialogActivityTheme);
            // 获取对话框的布局
            View layout = inflater.inflate(R.layout.dialog_promotion, null);
            // 为对话框添加布局和设置大小
            dialog.addContentView(layout, new WindowManager.LayoutParams(WindowManager.LayoutParams.MATCH_PARENT, WindowManager.LayoutParams.WRAP_CONTENT));
            this.imgBg = layout.findViewById(R.id.img_bg);
            if (this.act != null && !TextUtils.isEmpty(this.act.getBackground())) {

                GlideOptions options = GlideOptions.placeholderOf(com.ruiwenliu.wrapper.R.drawable.glide_icon_placeholder).
                        error(com.ruiwenliu.wrapper.R.drawable.glide_icon_error);

                Glide.with(mContext)
                        .asBitmap()
                        .load(this.act.getBackground())
                        .apply(options)
                        .into(new TransformationUtils(this.imgBg));
            }
            this.imgClose = layout.findViewById(R.id.img_close);
            layout.setOnClickListener(mListener);
            this.imgClose.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    dialog.dismiss();
                }
            });
            //默认不能点击对话框其他区域退出 和按返回键退出
            dialog.setCancelable(true);
            dialog.setContentView(layout);
            return dialog;
        }

    }

}
