package com.rv.points.view;

import android.app.Dialog;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;

import com.rv.component.utils.DisplayUtil;
import com.rv.points.R;

public class RegulationDialog extends Dialog {

    public RegulationDialog(@NonNull Context context) {
        super(context);
    }

    public RegulationDialog(Context context, int themeResId) {
        super(context, themeResId);
    }

    public static class Builder {

        private Context mContext;
        private TextView tvRuler;
        private TextView tvTitle ;
        private ImageView imgClose;
        private View.OnClickListener mListener;
        private String content;

        public Builder(Context context, View.OnClickListener listener) {
            mContext = context;
            this.mListener = listener;
        }

        public Builder(Context context) {
            mContext = context;
        }

        public Builder setContent(String content) {
            this.content = content;
            return this;
        }

        public Builder show() {
            final RegulationDialog dialog = create();
            dialog.show();
            return this;
        }

        /**
         * 创建定制的对话框
         */
        public RegulationDialog create() {
            LayoutInflater inflater = (LayoutInflater) mContext.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
            final RegulationDialog dialog = new RegulationDialog(mContext, R.style.DialogActivityTheme);
            // 获取对话框的布局
            View layout = inflater.inflate(R.layout.dialog_regulation, null);
            // 为对话框添加布局和设置大小
            dialog.addContentView(layout, new WindowManager.LayoutParams(WindowManager.LayoutParams.MATCH_PARENT, WindowManager.LayoutParams.WRAP_CONTENT));
            this.tvRuler = layout.findViewById(R.id.tv_ruler);
            if (!TextUtils.isEmpty(this.content)) {
                this.tvRuler.setText(this.content);
            }
            this.imgClose = layout.findViewById(R.id.img_close);
            this.imgClose.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    dialog.dismiss();
                }
            });
            this.tvTitle = layout.findViewById(R.id.tv_title) ;
            Drawable drawable = mContext.getResources().getDrawable(R.drawable.icon_point_ruler);
            drawable.setBounds(0, 0, DisplayUtil.dip2px(mContext, 20), DisplayUtil.dip2px(mContext, 20));
            tvTitle.setCompoundDrawables(drawable, null, null, null);
            tvTitle.setVisibility(View.VISIBLE);
            //默认不能点击对话框其他区域退出 和按返回键退出
            dialog.setCancelable(true);
            dialog.setContentView(layout);
            return dialog;
        }

    }

}
