package com.rv.member.view;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.rv.member.MemberCenterActivity;
import com.rv.member.R;
import com.rv.member.bean.MemberListBean;

public class MemberItemView extends LinearLayout {

    private TextView tv_member_type;
    private MemberCardView mcv_discount, mcv_free_day, mcv_free_outdoors;
    private TextView tv_describe;
//    private Button btn_buy;
    private View viewLine;

//    private boolean hasAgree = false;
    private MemberCenterActivity.PayListener listener;

    private MemberListBean.MemberCard memberCard = null;

    public MemberItemView(Context context) {
        super(context);
        initView();
    }

    public MemberItemView(Context context, AttributeSet attrs) {
        super(context, attrs);
        initView();
    }

//    public void setHasAgree(boolean hasAgree) {
//        this.hasAgree = hasAgree;
//    }

    public void setData(MemberListBean.MemberCard card) {
        this.memberCard = card;
        setData();
    }

    public void setListener(MemberCenterActivity.PayListener listener) {
        this.listener = listener;
    }

    public void hiddenLine() {
        if (viewLine != null) viewLine.setVisibility(GONE);
    }

    private void initView() {
        View view = LayoutInflater.from(getContext()).inflate(R.layout.item_member_detail, null);
        tv_member_type = view.findViewById(R.id.tv_member_type);
        mcv_discount = view.findViewById(R.id.mcv_discount);
        mcv_free_day = view.findViewById(R.id.mcv_free_day);
        mcv_free_outdoors = view.findViewById(R.id.mcv_free_outdoors);
        tv_describe = view.findViewById(R.id.tv_describe);
//        btn_buy = view.findViewById(R.id.btn_buy);
        viewLine = view.findViewById(R.id.view_line);
        addView(view);
    }

    private void setData() {
        if (!TextUtils.isEmpty(memberCard.getName())) {
            tv_member_type.setText(memberCard.getName());
//            btn_buy.setText("立即开通" + memberCard.getName());
//            if (memberCard.getLevel() == 1) {
//                btn_buy.setBackgroundResource(R.drawable.shape_rv_bg_open_normal_member);
//            } else if (memberCard.getLevel() == 2) {
//                btn_buy.setBackgroundResource(R.drawable.shape_rv_bg_open_gold_member);
//            } else {
//                btn_buy.setBackgroundResource(R.drawable.shape_rv_bg_open_diamond_member);
//            }
        }

//        btn_buy.setOnClickListener(new View.OnClickListener() {
//            @Override
//            public void onClick(View view) {
//                if (!hasAgree) {
//                    Toast.makeText(getContext(), "需同意服务协议", Toast.LENGTH_SHORT).show();
//                    return;
//                }
//                if (listener != null) {
//                    listener.pay(memberCard);
//                }
//            }
//        });
        if (!TextUtils.isEmpty(memberCard.getDescribe())) {
            tv_describe.setText(memberCard.getDescribe());
        }
        mcv_discount.setValue(memberCard.getDiscount());
        mcv_free_day.setValue(memberCard.getNumber());
        mcv_free_outdoors.setValue(memberCard.getLevel());
    }
}
