package com.rv.member.view;

import android.content.Context;
import android.content.Intent;
import android.graphics.Typeface;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.style.TextAppearanceSpan;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.base.utils.ui.image.round.RoundImageView;
import com.ruiwenliu.wrapper.bean.UserInfoBean;
import com.ruiwenliu.wrapper.util.glide.GlideManager;
import com.rv.component.utils.DisplayUtil;
import com.rv.member.ConsumeRecordActivity;
import com.rv.member.MemberCenterActivity;
import com.rv.member.PurchaseRecordActivity;
import com.rv.member.R;

public class LoginView extends LinearLayout {

    private LinearLayout llLogin;
    private RoundImageView ivAvatar;
    private TextView tvNickname;
    private ImageView ivMemberLevel;
    private TextView tvConsumeRecord;
    private TextView tvFreeDay;
    private TextView tvPurchaseRecord;

    private UserInfoBean infoBean;

    public LoginView(Context context) {
        super(context);
        initView();
    }

    public LoginView(Context context, AttributeSet attrs) {
        super(context, attrs);
        initView();
    }

    public void setData(UserInfoBean infoBean) {
        this.infoBean = infoBean;
        setViewData();
    }

    private void setViewData() {
        if (infoBean != null) {
            UserInfoBean.UserInfo info = infoBean.getData();
            if (info != null) {
                if (info.getIsMember() == 0) {
                    llLogin.setBackgroundResource(R.drawable.shape_rv_bg_top_unlogin);
                    ivMemberLevel.setVisibility(INVISIBLE);
                } else {
                    switch (info.getMemberLevel()) {
                        case 1:
                            llLogin.setBackgroundResource(R.drawable.member_common_background);
                            break;
                        case 2:
                            llLogin.setBackgroundResource(R.drawable.member_gold_background);
                            break;
                        case 3:
                            llLogin.setBackgroundResource(R.drawable.member_diamond_background);
                            break;
                        default:
                            break;
                    }
                }

                GlideManager.getInstance(getContext()).loadImage(info.getHeadimgurl(), ivAvatar);
                tvNickname.setText(!TextUtils.isEmpty(info.getNickname()) ? info.getNickname() : info.getUsername());

                SpannableStringBuilder recordBuilder = new SpannableStringBuilder(info.getPayCount() + "\n 消费记录/次");
                recordBuilder.setSpan(new TextAppearanceSpan(null, Typeface.NORMAL, DisplayUtil.sp2px(getContext(), 18), null, null), 0, String.valueOf(info.getPayCount()).length(), Spanned.SPAN_EXCLUSIVE_INCLUSIVE);
                tvConsumeRecord.setText(recordBuilder);

                SpannableStringBuilder rentBuilder = new SpannableStringBuilder(info.getRentFreeDays() + "\n 可免费租车/天");
                rentBuilder.setSpan(new TextAppearanceSpan(null, Typeface.NORMAL, DisplayUtil.sp2px(getContext(), 18), null, null), 0, String.valueOf(info.getRentFreeDays()).length(), Spanned.SPAN_EXCLUSIVE_INCLUSIVE);

                tvFreeDay.setText(rentBuilder);

                SpannableStringBuilder bugBuilder = new SpannableStringBuilder(info.getBuyCount() + "\n 购买记录/次");
                bugBuilder.setSpan(new TextAppearanceSpan(null, Typeface.NORMAL, DisplayUtil.sp2px(getContext(), 18), null, null), 0, String.valueOf(info.getBuyCount()).length(), Spanned.SPAN_EXCLUSIVE_INCLUSIVE);
                tvPurchaseRecord.setText(bugBuilder);
                if (!TextUtils.isEmpty(info.getBigIcon()))
                    GlideManager.getInstance(getContext()).loadImage(info.getBigIcon(), ivMemberLevel);
            }
        }
    }


    private void initView() {
        View view = LayoutInflater.from(getContext()).inflate(R.layout.item_login_view, null);
        llLogin = view.findViewById(R.id.ll_login);
        ivAvatar = view.findViewById(R.id.iv_avatar);
        tvNickname = view.findViewById(R.id.tv_nickname);
        ivMemberLevel = view.findViewById(R.id.iv_member_level);
        tvConsumeRecord = view.findViewById(R.id.tv_consume_record);
        tvFreeDay = view.findViewById(R.id.tv_free_day);
        tvPurchaseRecord = view.findViewById(R.id.tv_purchase_record);
        tvConsumeRecord.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                getContext().startActivity(new Intent(getContext(), ConsumeRecordActivity.class));
            }
        });
        tvPurchaseRecord.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                getContext().startActivity(new Intent(getContext(), PurchaseRecordActivity.class));
            }
        });
        addView(view);
    }
}
