package com.rv.member;

import android.content.Intent;
import android.os.Bundle;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.entity.MultiItemEntity;
import com.frame.rv.config.RvFrameConfig;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseStatusActivity;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.ruiwenliu.wrapper.weight.refresh.SimpleRefreshLayout;
import com.ruiwenliu.wrapper.weight.refresh.SimpleRefreshView;
import com.rv.home.R2;
import com.rv.home.rv.module.ApiConfig;
import com.ruiwenliu.wrapper.base.presenter.CommonPresenter;
import com.rv.home.rv.module.ui.main.home.order.MemberOrderDetailsActivity;
import com.rv.home.rv.module.ui.main.home.order.adapter.CompletedAdapter;
import com.rv.home.rv.module.ui.main.home.order.bean.OrderListBean;
import com.yuyife.okgo.OkGoUtil;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

import butterknife.BindView;

public class PurchaseRecordActivity extends BaseStatusActivity<CommonPresenter> implements BaseQuickAdapter.RequestLoadMoreListener, SimpleRefreshLayout.OnSimpleRefreshListener {

    @BindView(com.rv.home.R2.id.recyclerView)
    RecyclerView recyclerView;
    @BindView(R2.id.refresh)
    SimpleRefreshLayout mSimpleRefreshLayout;
    CompletedAdapter mAdapter;
    private int mPage = 1;
    private int countPage;
    private final int TYPE_REQUEST_EVALUATION = 1;

    @Override
    protected int setLayout() {
        return R.layout.activity_purchase_record;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        titleView.setTitle("购买记录");
        recyclerView.setLayoutManager(new LinearLayoutManager(this));
        mAdapter = new CompletedAdapter(new ArrayList<MultiItemEntity>());
        mAdapter.setOnLoadMoreListener(this, recyclerView);
        mSimpleRefreshLayout.setHeaderView(new SimpleRefreshView(this));
        mSimpleRefreshLayout.setOnSimpleRefreshListener(this);
        recyclerView.setAdapter(mAdapter);

        mAdapter.setOnItemClickListener(new BaseQuickAdapter.OnItemClickListener() {
            @Override
            public void onItemClick(BaseQuickAdapter adapter, View view, int position) {
                OrderListBean.DataBeanX.DataBean dataBean = (OrderListBean.DataBeanX.DataBean) adapter.getItem(position);
                startActivity(MemberOrderDetailsActivity.getIntent(PurchaseRecordActivity.this, dataBean.getNo()));
            }
        });
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {
        switch (requestType) {
            case 0:
                processData((OrderListBean) result);
                break;
        }
    }

    @Override
    protected void loadData(Bundle savedInstanceState, Intent intent) {
        super.loadData(savedInstanceState, intent);
        orderData(mPage);
    }

    @Override
    public void onRefresh() {
        mPage = 1;
        orderData(mPage);
    }

    @Override
    public void onLoadMoreRequested() {
        if (mPage >= countPage) {
            mAdapter.loadMoreEnd();
        } else {
            mPage++;
            orderData(mPage);

        }
    }


    private void orderData(int page) {
        Map<String, Object> headMap = new LinkedHashMap<>();
        if (OkGoUtil.getToken() != null)
            headMap.put("Authorization", OkGoUtil.getToken());
        Map<String, Object> mapData = new LinkedHashMap<>();
        mapData.put("page", page);
        mapData.put("limit", 10);
        mapData.put("status", 6);
        mapData.put("type", 3);
        mPresenter.getData(RvFrameConfig.VEHICLE_ORDER, 0, ApiConfig.HTTP_URL_ORDER_LIST, OrderListBean.class, mapData, headMap, page == 1 ? true : false);
    }

    /**
     * 处理请求数据
     *
     * @param bean
     */
    private void processData(OrderListBean bean) {
        if (mPage == 1) {
            countPage = bean.getData().getTotalPage();
            mAdapter.addNewData(bean);
            mSimpleRefreshLayout.onRefreshComplete();
            if (bean.getData().getTotalCount() == 0) {
                mAdapter.setEmptyView(getEmptyView(recyclerView, -1, getString(R.string.rv_select_not_data)));
                mAdapter.notifyDataSetChanged();
            }

        } else {
            mAdapter.addData(bean.getData().getData());
            mAdapter.loadMoreComplete();
        }
    }

    @Override
    public void onShowError(String errorMsg, int errorType) {
        super.onShowError(errorMsg, errorType);
        if (mPage == 1)
            mSimpleRefreshLayout.onRefreshComplete();
    }

}
