package com.xxrv.invoice.adapter;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.xxrv.invoice.R;
import com.xxrv.invoice.bean.OrderInvoicingCarBean;

import java.util.ArrayList;
import java.util.List;

/**
 * 按订单开票 租车 item
 */

public class OrderInvoicingCarAdapter extends BaseQuickAdapter<OrderInvoicingCarBean.DataBeanX.DataBean, BaseViewHolder> {

    public OrderInvoicingCarAdapter() {
        super(R.layout.rv_item_order_invoicing_car);
    }

    @Override
    protected void convert(BaseViewHolder helper, final OrderInvoicingCarBean.DataBeanX.DataBean item) {
        if (item.getSelectType() == 1) {
            helper.setChecked(R.id.cb_select, true);
        } else {
            helper.setChecked(R.id.cb_select, false);
        }

        helper.addOnClickListener(R.id.ll_item_bg);
        helper.addOnClickListener(R.id.cb_select);
    }

    public int getPosition(OrderInvoicingCarBean.DataBeanX.DataBean item) {
        return mData.indexOf(item);
    }


    public void setItemState(int position) {
        mData.get(position).setSelectType(mData.get(position).getSelectType() == 0 ? 1 : 0);
        notifyItemChanged(position);
    }


    public List<OrderInvoicingCarBean.DataBeanX.DataBean> getSelectItem() {
        List<OrderInvoicingCarBean.DataBeanX.DataBean> list = new ArrayList<>();
        for (OrderInvoicingCarBean.DataBeanX.DataBean dataBean : mData) {
            if (dataBean.getSelectType() == 1) {
                list.add(dataBean);
            }
        }
        return list;
    }
}
