package com.xxrv.invoice.activity;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.CheckBox;
import android.widget.ImageView;
import android.widget.TextView;

import com.alibaba.android.arouter.launcher.ARouter;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.frame.base.url.Constance;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseStatusActivity;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.xxrv.invoice.R;
import com.xxrv.invoice.R2;
import com.xxrv.invoice.adapter.OrderInvoicingCarAdapter;
import com.xxrv.invoice.api.InvoiceApi;
import com.xxrv.invoice.bean.OrderInvoicingCarBean;
import com.xxrv.invoice.presenter.InvoicePresenter;

import java.util.ArrayList;
import java.util.List;

import butterknife.BindView;
import butterknife.ButterKnife;
import butterknife.OnClick;

/**
 * 租车开发票订单列表
 */
public class OrderInvoicingCarActivity extends BaseStatusActivity<InvoicePresenter> {

    @BindView(R2.id.rv_content)
    RecyclerView rvContent;
    @BindView(R2.id.tv_number)
    TextView tvNumber;
    @BindView(R2.id.tv_price)
    TextView tvPrice;
    @BindView(R2.id.cb_all)
    CheckBox cbAll;
    @BindView(R2.id.iv_noorder_hint)
    ImageView ivNoorderHint;
    @BindView(R2.id.tv_item_next)
    TextView tvItemNext;

    private OrderInvoicingCarAdapter mAdapter;

    private boolean isCheckAll = true;

    public static Intent getIntent(Context context) {
        return new Intent(context, OrderInvoicingCarActivity.class);
    }

    @Override
    protected int setLayout() {
        return R.layout.activity_order_invoicing_car;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        titleView.setTitle("按订单开票");

        mAdapter = new OrderInvoicingCarAdapter();
        rvContent.setLayoutManager(new LinearLayoutManager(mActivity, LinearLayoutManager.VERTICAL, false));
        rvContent.setAdapter(mAdapter);


        mAdapter.setOnItemChildClickListener(new BaseQuickAdapter.OnItemChildClickListener() {
            @Override
            public void onItemChildClick(BaseQuickAdapter adapter, View view, int position) {
                if (view.getId() == R.id.ll_item_bg || view.getId() == R.id.cb_select) {
                    mAdapter.setItemState(position);
                    getCountSelectData();
                    if (mAdapter.getData().size() != mAdapter.getSelectItem().size()) {
                        cbAll.setChecked(false);
                        isCheckAll = true;
                    } else {
                        cbAll.setChecked(true);
                        isCheckAll = false;
                    }
                }
            }
        });


        setData();
    }

    private void getCountSelectData() {
        List<OrderInvoicingCarBean.DataBeanX.DataBean> selectItem = mAdapter.getSelectItem();
        tvNumber.setText(String.valueOf(selectItem.size()));

        if (selectItem.size() > 0) {
            tvItemNext.setBackgroundResource(R.drawable.shape_rv_bg_shallow_dark_yellow_circle);
            tvItemNext.setEnabled(true);
        } else {
            tvItemNext.setBackgroundResource(R.drawable.shape_rv_bg_shallow_dark_yellow_circle2);
            tvItemNext.setEnabled(false);
        }
    }

    private void setAllSelect(int type) {
        List<OrderInvoicingCarBean.DataBeanX.DataBean> data = mAdapter.getData();
        if (data != null && data.size() > 0) {
            for (int i = 0; i < data.size(); i++) {
                data.get(i).setSelectType(type);
                mAdapter.notifyItemChanged(i);
            }
        }
    }

    private void setData() {
        ArrayList<OrderInvoicingCarBean.DataBeanX.DataBean> objects = new ArrayList<>();
        for (int i = 0; i < 5; i++) {
            objects.add(new OrderInvoicingCarBean.DataBeanX.DataBean());
        }
        mAdapter.addData(objects);
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {

    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        // TODO: add setContentView(...) invocation
        ButterKnife.bind(this);
    }

    @OnClick({R2.id.tv_item_hint, R2.id.cb_all, R2.id.tv_item_next})
    public void onViewClicked(View view) {
        int id = view.getId();
        if (id == R.id.tv_item_hint) {
            ARouter.getInstance().build(Constance.ACTIVITY_URL_WEBVIEW)
                    .withString("title", "按订单开票")
                    .withString("url", InvoiceApi.HTTP_URL_CAR_TYPE_NOTICE)
                    .withInt("type", 27)
                    .navigation();
        } else if (id == R.id.cb_all) {

            if (isCheckAll) {
                setAllSelect(1);
                cbAll.setChecked(true);
            } else {
                setAllSelect(0);
                cbAll.setChecked(false);
            }
            isCheckAll = !isCheckAll;
            getCountSelectData();

        } else if (id == R.id.tv_item_next) {
            startActivity(OrderInvoicingCarDetailsActivity.getIntent(mActivity));
        }
    }
}
