package com.xxrv.invoice.activity;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;

import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.frame.base.url.Constance;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseStatusActivity;
import com.ruiwenliu.wrapper.util.ViewHolder;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.xxrv.invoice.R;
import com.xxrv.invoice.R2;
import com.xxrv.invoice.api.InvoiceApi;
import com.xxrv.invoice.dialog.InvoicingAnnouncementDialog;
import com.xxrv.invoice.presenter.InvoicePresenter;

import butterknife.ButterKnife;
import butterknife.OnClick;

/**
 * 开具发票
 */
@Route(path = Constance.ACTIVITY_URL_INVOICINGACTIVITY)
public class InvoicingActivity extends BaseStatusActivity<InvoicePresenter> {

    @Override
    protected int setLayout() {
        return R.layout.activity_invoicing;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        titleView.setTitle("开具发票");
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {

    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        ButterKnife.bind(this);
    }

    @OnClick({R2.id.rl_item_announcement, R2.id.rl_item_car, R2.id.rl_item_tourism, R2.id.rl_item_member, R2.id.rl_item_billing_history, R2.id.rl_item_invoicing_help, R2.id.tv_item_customer_service})
    public void onViewClicked(View view) {
        int id = view.getId();
        if (id == R.id.rl_item_announcement) {
            showAnnouncement();
        } else if (id == R.id.rl_item_car) {

            startActivity(OrderInvoicingCarActivity.getIntent(mActivity));
        } else if (id == R.id.rl_item_tourism) {

        } else if (id == R.id.rl_item_member) {

        } else if (id == R.id.rl_item_billing_history) {

            startActivity(BillingHistoryActivity.getIntent(mActivity));
        } else if (id == R.id.rl_item_invoicing_help) {

            ARouter.getInstance().build(Constance.ACTIVITY_URL_WEBVIEW)
                    .withString("title", "开票帮助")
                    .withString("url", InvoiceApi.HTTP_URL_CAR_TYPE_NOTICE)
                    .withInt("type", 27)
                    .navigation();
        } else if (id == R.id.tv_item_customer_service) {

        }
    }

    /**
     * 公告show
     */
    private void showAnnouncement() {
        new InvoicingAnnouncementDialog(mActivity) {
            @Override
            public void helper(ViewHolder helper) {
                super.helper(helper);
                helper.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        int id = v.getId();
                        if (id == R.id.ll_item_ok) {
                            dismiss();
                        }
                    }
                }, R.id.ll_item_ok);
            }
        }.show();
    }
}
