package com.xxrv.invoice.activity;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.widget.ImageView;

import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseStatusActivity;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.xxrv.invoice.R;
import com.xxrv.invoice.R2;
import com.xxrv.invoice.adapter.InvoiceBillingHistoryAdapter;
import com.xxrv.invoice.presenter.InvoicePresenter;

import java.sql.Array;
import java.util.ArrayList;

import butterknife.BindView;
import butterknife.ButterKnife;

/**
 * 开票历史
 */
public class BillingHistoryActivity extends BaseStatusActivity<InvoicePresenter> {

    @BindView(R2.id.rv_content)
    RecyclerView rvContent;
    @BindView(R2.id.iv_noorder_hint)
    ImageView ivNoorderHint;

    private InvoiceBillingHistoryAdapter adapter;

    public static Intent getIntent(Context context) {
        return new Intent(context, BillingHistoryActivity.class);
    }

    @Override
    protected int setLayout() {
        return R.layout.activity_billing_history;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        titleView.setTitle("开票历史");

        adapter = new InvoiceBillingHistoryAdapter();
        rvContent.setLayoutManager(new LinearLayoutManager(mActivity, LinearLayoutManager.VERTICAL, false));
        rvContent.setAdapter(adapter);

        setData();
    }

    private void setData() {
        ArrayList<String> list = new ArrayList<>();
        for (int i = 0; i < 5; i++) {
            list.add("33333");
        }
        adapter.addData(list);
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {

    }
}
