package com.rv.im.log;

import android.content.Context;
import android.text.TextUtils;

import java.io.File;

public class FilePathGgenerator {

    protected String dir = "";
    protected String filename = "app";
    protected String suffix = ".log";
    private String path = null;

    public FilePathGgenerator(Context context, String filename, String suffix) {
        if (context == null) {
            throw new NullPointerException("FilePathGgenerator context is null");
        }

        this.dir = context.getExternalCacheDir() + File.separator + "log";
        if (!TextUtils.isEmpty(filename)) {
            this.filename = filename;
        }
        if (!TextUtils.isEmpty(suffix)) {
            this.suffix = suffix;
        }
        this.path = dir + File.separator + filename + suffix;
    }

    public FilePathGgenerator(String dir, String filename, String suffix) {
        if (!TextUtils.isEmpty(dir)) {
            this.dir = dir;
        }
        if (!TextUtils.isEmpty(filename)) {
            this.filename = filename;
        }
        if (!TextUtils.isEmpty(suffix)) {
            this.suffix = suffix;
        }
        this.path = dir + File.separator + filename + suffix;
    }

    public String getPath() {
        return this.path;
    }

    public String getDir() {
        return this.dir;
    }
}
