package com.rv.im.db.table;

import com.google.gson.annotations.SerializedName;
import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import com.rv.im.enums.MessageTypeEnum;

@DatabaseTable(tableName = "tb_customer")
public class Customer {
    @DatabaseField(columnName = "_id", dataType = DataType.INTEGER, generatedId = true)
    private int _id;

    @SerializedName(value = "id")
    @DatabaseField
    private int customerId;

    @DatabaseField
    private String name;
    @DatabaseField
    private String password;
    @DatabaseField
    private String imUserId;
    @DatabaseField
    private String telphone;
    @DatabaseField
    private String createTime;

    private String lastMsg;

    private long lastMsgTimes;

    private int unReadMessage ;

    public int get_id() {
        return _id;
    }

    public void set_id(int _id) {
        this._id = _id;
    }

    public int getCustomerId() {
        return customerId;
    }

    public void setCustomerId(int customerId) {
        this.customerId = customerId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getImUserId() {
        return imUserId;
    }

    public void setImUserId(String imUserId) {
        this.imUserId = imUserId;
    }

    public String getTelphone() {
        return telphone;
    }

    public void setTelphone(String telphone) {
        this.telphone = telphone;
    }

    public String getCreateTime() {
        return createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getLastMsg() {
        return lastMsg;
    }

    public void setLastMsg(String lastMsg) {
        this.lastMsg = lastMsg;
    }

    public long getLastMsgTimes() {
        return lastMsgTimes;
    }

    public void setLastMsgTimes(long lastMsgTimes) {
        this.lastMsgTimes = lastMsgTimes;
    }

    public int getUnReadMessage() {
        return unReadMessage;
    }

    public void setUnReadMessage(int unReadMessage) {
        this.unReadMessage = unReadMessage;
    }

    public void setLastMessageInfo(ChatMessage lastMessageInfo) {

        if (lastMessageInfo.getMessageType() == MessageTypeEnum.TEXT.getType()) {
            setLastMsg(lastMessageInfo.getContent());
        } else if (lastMessageInfo.getMessageType() == MessageTypeEnum.PIC.getType()) {
            setLastMsg("[图片]");
        } else if (lastMessageInfo.getMessageType() == MessageTypeEnum.FILE.getType()) {
            setLastMsg("[文件]");
        } else if (lastMessageInfo.getMessageType() == MessageTypeEnum.VOICE.getType()) {
            setLastMsg("[语音]");
        } else if (lastMessageInfo.getMessageType() == MessageTypeEnum.VOLTE_CALL.getType()) {
            setLastMsg("[语音通话]");
        } else if (lastMessageInfo.getMessageType() == MessageTypeEnum.VIDEO_CALL.getType()) {
            setLastMsg("[视频]");
        }
        setLastMsgTimes(lastMessageInfo.getTimeSend());
    }
}
