package com.rv.im.db.dao;

import android.content.Context;
import android.util.Log;

import com.j256.ormlite.android.apptools.OpenHelperManager;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.rv.im.db.SQLiteHelper;
import com.rv.im.db.table.ChatConversation;
import com.rv.im.log.LogUtil;

import java.sql.SQLException;
import java.util.List;

public class ConversationDao {

    private static final String TAG = ConversationDao.class.getSimpleName();
    private static ConversationDao instance = null;
    public Dao<ChatConversation, Integer> dao;
    private SQLiteHelper mHelper;
    private Context mContext;

    private ConversationDao(Context context) {
        try {
            this.mContext = context;
            dao = DaoManager.createDao(SQLiteHelper.getInstance(context).getConnectionSource(), ChatConversation.class);
        } catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static final ConversationDao getInstance(Context context) {

        return new ConversationDao(context);
    }


    @Override
    protected void finalize() throws Throwable {
        super.finalize();
        OpenHelperManager.releaseHelper();
    }

    public List<ChatConversation> getAllConversation() {
        if (dao == null) {
            LogUtil.e(TAG, "dao is null");
            return null;
        }
        List<ChatConversation> chatConversations = null;
        try {
            chatConversations = dao.queryForAll();
        } catch (SQLException e) {
            e.printStackTrace();
        }
        return chatConversations;
    }


    /*******
     * 插入消息
     * @param conversation
     */
    public void addConversation(ChatConversation conversation) {
        if (dao == null) {
            LogUtil.e(TAG, "dao is null");
            return;
        }
        if (conversation == null) {
            LogUtil.e(TAG, "conversation is null");
            return;
        }
        Log.d(TAG, conversation.toString());
        if (isExit(conversation)) {
            updateConversation(conversation);
            return;
        }
        try {
            int result = dao.create(conversation);
            LogUtil.d(TAG, "插入结果 " + result);
        } catch (SQLException e) {
            e.printStackTrace();
            LogUtil.d(TAG, "插入失败 " + e.getMessage());
        }
    }

    /*****
     * 更新消息
     * @param conversation
     */
    public void updateConversation(ChatConversation conversation) {
        if (dao == null) {
            LogUtil.e(TAG, "dao is null");
            return;
        }
        if (conversation == null) {
            LogUtil.e(TAG, "message is null");
            return;
        }
        try {
            dao.update(conversation);
        } catch (SQLException e) {
            e.printStackTrace();
        }
    }

    /*******
     * 判断是否存在会话
     * @param conversation
     * @return
     */
    public boolean isExit(ChatConversation conversation) {
        if (dao == null) {
            LogUtil.e(TAG, "dao is null");
            return false;
        }
        if (conversation == null) {
            LogUtil.e(TAG, "conversation is null");
            return false;
        }
        try {
            List<ChatConversation> lists = dao.queryForEq("userId", conversation.getUserId());
            return lists == null ? false : lists.size() == 0 ? false : true;
        } catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

}
