package com.rv.im.adapter;

import android.content.Context;
import android.graphics.Color;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.rv.im.R;
import com.rv.im.db.table.Customer;
import com.rv.im.util.SmileyParser;

import java.util.List;
import java.util.Map;

public class CustomerListAdapter extends BaseQuickAdapter<Customer, BaseViewHolder> {

    private SmileyParser parser;

    private Map<String, Integer> customerStatus;

    public CustomerListAdapter(Context context, @Nullable List<Customer> data, Map<String, Integer> map) {
        super(R.layout.item_customer, data);
        this.parser = SmileyParser.getInstance(context);
        this.customerStatus = map;
    }

    @Override
    protected void convert(BaseViewHolder helper, Customer item) {
        if (!TextUtils.isEmpty(item.getName()))
            helper.setText(R.id.tv_name, item.getName());

        if (customerStatus.get(item.getImUserId()) != null && customerStatus.get(item.getImUserId()) == 1) {
            helper.setText(R.id.tv_state, "在线");
            helper.setTextColor(R.id.tv_state, Color.parseColor("#FFB74B"));
        } else {
            helper.setText(R.id.tv_state, "离线");
            helper.setTextColor(R.id.tv_state, Color.parseColor("#CCCCCC"));
        }

        if (!TextUtils.isEmpty(item.getLastMsg()))
            helper.setText(R.id.tv_last_msg, parser.addSmileySpans(deleteHtml(item.getLastMsg()), true));
        else {
            helper.setText(R.id.tv_last_msg, " ");
        }

        if (item.getUnReadMessage() > 0) {

            if(item.getUnReadMessage() < 100){
                helper.setText(R.id.tv_unread_num, item.getUnReadMessage() + "");
            }else{
                helper.setText(R.id.tv_unread_num, "···");
            }
            helper.itemView.findViewById(R.id.tv_unread_num).setVisibility(View.VISIBLE);
            helper.itemView.findViewById(R.id.img_no_unread).setVisibility(View.GONE);
        } else {
            helper.itemView.findViewById(R.id.tv_unread_num).setVisibility(View.GONE);
            helper.itemView.findViewById(R.id.img_no_unread).setVisibility(View.VISIBLE);
        }
    }

    private static String deleteHtml(String msg) {
        if (msg == null) {
            return "";
        }
        msg = msg.replaceAll("\n", "\r\n");
        return msg;
    }
}
