package com.rv.plugin.calendar;

import android.view.View;

import com.rv.plugin.calendar.adapter.ArrayWheelAdapter;
import com.rv.plugin.calendar.listener.OnItemSelectedListener;

import java.util.ArrayList;

public class WheelTime2
{
	private View view;
	private WheelView3 wv_hours;
	private ArrayList<String> timeList;
	private String time;


	public WheelTime2(View view, ArrayList<String> timeList)
	{
		super();
		this.view = view;
		this.timeList =timeList;
		setView(view);
	}

	/**
	 * @Description: TODO 弹出时间选择器
	 */
	public void setPicker(int h)
	{

		wv_hours = (WheelView3) view.findViewById(R.id.hour);
		wv_hours.setAdapter(new ArrayWheelAdapter(timeList,timeList.size()));
		/*wv_hours.setCurrentItem(h);
		time = timeList.get(h);*/

		// 添加时间滑动监听
		OnItemSelectedListener wheelListener = new OnItemSelectedListener()
		{
			@Override
			public void onItemSelected(int index)
			{
				time = timeList.get(index);
				System.out.println("wv_hours--->"+index);
				System.out.println("wv_hours-------->"+wv_hours.getCurrentItem());
			}
		};

		wv_hours.setOnItemSelectedListener(wheelListener);
		wv_hours.setTextSize(24);

	}

	/**
	 * 设置是否循环滚动
	 * 
	 * @param cyclic
	 */
	public void setCyclic(boolean cyclic)
	{
		wv_hours.setCyclic(cyclic);
	}

	public void setCurrentItem(int num)
	{
		wv_hours.setCurrentItem(num);
		time = timeList.get(num);
	}


	public String getTime()
	{
		return time;
	}

	public View getView()
	{
		return view;
	}

	public void setView(View view)
	{
		this.view = view;
	}

}
