package com.rv.tourism.presenter;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;

import com.frame.rv.config.RvFrameConfig;
import com.ruiwenliu.wrapper.presenter.MvpPresenter;

/**
 * Created by Amuse
 * Date:2019/3/4.
 * Desc:
 */

public class TourismPresenter extends MvpPresenter {


    @Override
    /**
     * 域名地址
     */
    public String getBaseUrl() {
        return RvFrameConfig.AUTH_POST;
    }

    /******
     * 打开目标页面
     * @param context
     * @param url
     * @param title
     */
    public void toTarget(Context context, String url, String title) {
        if (url.startsWith("http")) {
            ComponentName componentName = new ComponentName(context, "com.rv.share.WebViewActivity");
            Intent intent = new Intent();
            intent.setComponent(componentName);
            intent.putExtra("url", url);
            intent.putExtra("title", title);
            context.startActivity(intent);
        } else if (url.startsWith("app:")) {
            String target = null;
            String[] params = null;
            if (url.contains("?")) {
                target = url.substring(url.indexOf(":") + 1, url.indexOf("?"));
                String paramsString = url.substring(url.indexOf("?") + 1);
                params = paramsString.split("&");
            } else {
                target = url.substring(url.indexOf(":") + 1);
            }
            if (!TextUtils.isEmpty(target)) {
                ComponentName componentName = new ComponentName(context, target);
                Intent intent = new Intent();
                intent.setComponent(componentName);
                if (params != null && params.length > 0) {
                    for (String param : params) {
                        String[] values = param.split("=");
                        if (values.length == 2) {

                            if ("price".equals(values[0])) {
                                intent.putExtra(values[0], Double.valueOf(values[1]));
                            } else {
                                intent.putExtra(values[0], values[1]);
                            }
                        }
                    }
                }
                context.startActivity(intent);
            }
        }
    }
}
