package com.rv.tourism.adapter;

import android.widget.ImageView;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.ruiwenliu.wrapper.util.glide.GlideManager;
import com.rv.tourism.R;
import com.rv.tourism.bean.BeanTourAround;

/**
 * 周边游  adapter
 */
public class TourAroundAdapter extends BaseQuickAdapter<BeanTourAround.DataBeanX.DataBean, BaseViewHolder> {
    public TourAroundAdapter() {
        super(R.layout.rv_item_tour_around);
    }

    @Override
    protected void convert(BaseViewHolder helper, BeanTourAround.DataBeanX.DataBean item) {
        GlideManager.getInstance(mContext).loadRoundImage(item.getCover(),  (ImageView)helper.getView(R.id.iv_icon),10);
         helper.setText(R.id.tv_title,item.getName());
//         helper.setText(R.id.tv_city,item.get)
        helper.setText(R.id.tv_people,item.getStock());
        helper.setText(R.id.tv_price,String.format("¥%1$s%2$s",item.getPrice(),item.getUnit()));
    }
}
