package com.rv.rvmine.traveler;

import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.KeyEvent;

import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseStatusActivity;
import com.ruiwenliu.wrapper.base.presenter.CommonPresenter;
import com.ruiwenliu.wrapper.bean.UserInfoBean;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.rv.component.utils.CacheEnum;
import com.rv.component.utils.RvCache;
import com.rv.rvmine.R;
import com.rv.rvmine.SwitchFragmentListener;
import com.rv.rvmine.fragment.BindPhoneFirstFragment;
import com.rv.rvmine.fragment.BindPhoneSecondFragment;
import com.rv.rvmine.fragment.BindPhoneThirdFragment;

public class BindPhoneActivity extends BaseStatusActivity<CommonPresenter> implements SwitchFragmentListener {

    private int currentPage = 1;

    private UserInfoBean bean;

    private BindPhoneFirstFragment firstFragment;

    private BindPhoneSecondFragment secondFragment;

    private BindPhoneThirdFragment thirdFragment;

    private boolean isChanged;

    @Override
    protected int setLayout() {
        return R.layout.activity_bind_phone;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        bean = (UserInfoBean) intent.getSerializableExtra("user");
        firstFragment = new BindPhoneFirstFragment();
        if (bean != null) {
            Bundle bundle = new Bundle();
            bundle.putString("phone", bean.getData().getUsername());
            firstFragment.setArguments(bundle);
        }
        getSupportFragmentManager().beginTransaction().replace(R.id.fl_content, firstFragment)
                .addToBackStack(null).commit();
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {

    }


    @Override
    public void setTitle(String title) {
        if (!TextUtils.isEmpty(title))
            titleView.setTitle(title);
    }

    @Override
    public void next() {
        switch (currentPage) {
            case 1:
                secondFragment = new BindPhoneSecondFragment();
                if (bean != null) {
                    Bundle bundle = new Bundle();
                    bundle.putString("phone", bean.getData().getUsername());
                    secondFragment.setArguments(bundle);
                }
                getSupportFragmentManager().beginTransaction().replace(R.id.fl_content, secondFragment)
                        .addToBackStack(null).commit();
                currentPage = 2;
                break;
            case 2:
                thirdFragment = new BindPhoneThirdFragment();
                if (bean != null) {
                    Bundle bundle = new Bundle();
                    bundle.putString("phone", bean.getData().getUsername());
                    thirdFragment.setArguments(bundle);
                }
                getSupportFragmentManager().beginTransaction().replace(R.id.fl_content, thirdFragment)
                        .addToBackStack(null).commit();
                currentPage = 3;
                break;
        }
    }

    @Override
    public void changeSuccess(String phone) {
        isChanged = true;
        bean.getData().setUsername(phone);
        RvCache.getInstance().save(bean, CacheEnum.USER);
        Bundle bundle = new Bundle();
        bundle.putString("phone", bean.getData().getUsername());
        firstFragment.setArguments(bundle);
        getSupportFragmentManager().beginTransaction().replace(R.id.fl_content, firstFragment)
                .addToBackStack(null).commit();
        currentPage = 1;
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == KeyEvent.KEYCODE_BACK) {
            finish();
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    @Override
    public void finish() {
        if (currentPage > 1) {
            getSupportFragmentManager().popBackStack();
            currentPage -= 1;
        } else {
            if (isChanged) {
                Intent intent = new Intent();
                intent.putExtra("phone", bean.getData().getUsername());
                setResult(RESULT_OK,intent);
            }
            super.finish();
        }
    }
}
