package com.rv.rvmine.traveler;

import android.content.Intent;
import android.graphics.Color;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.View;
import android.widget.EditText;

import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseStatusActivity;
import com.ruiwenliu.wrapper.base.presenter.CommonPresenter;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.rv.rvmine.R;
import com.rv.rvmine.R2;

import butterknife.BindView;

public class AlterNickNameActivity extends BaseStatusActivity<CommonPresenter> {
    @BindView(R2.id.et_nickname)
    EditText etNickname;

    @Override
    protected int setLayout() {
        return R.layout.activity_alter_nick_name;

    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        titleView.setTitle("个人资料");
        titleView.setText(R.id.tv_title_right, "保存");
        titleView.setTextColor(R.id.tv_title_right, Color.parseColor("#666666"));
        titleView.setChildClickListener(R.id.tv_title_right, new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                upUserinfo();
            }
        });
        String nickName = intent.getStringExtra("nick");
        if (!TextUtils.isEmpty(nickName)) {
            etNickname.setText(nickName);
            if (nickName.length() <= 32) {
                etNickname.setSelection(nickName.length());
            } else {
                etNickname.setSelection(32);
            }
        }
    }

    private void upUserinfo() {
        if (TextUtils.isEmpty(getNickName())) {
            showToast("昵称不能为空");
            return;
        }
        Intent intent = new Intent();
        intent.putExtra("nick", getNickName());
        setResult(RESULT_OK, intent);
        finish();
    }

    private String getNickName() {
        return etNickname.getText().toString().trim();
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {

    }
}
