package com.rv.home.rv.module.ui.main.home.order;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.frame.rv.config.RvFrameConfig;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseStatusActivity;
import com.ruiwenliu.wrapper.util.TimeManager;
import com.ruiwenliu.wrapper.util.glide.GlideManager;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.rv.component.utils.DisplayUtil;
import com.rv.component.utils.ZxingUtils;
import com.rv.home.R;
import com.rv.home.R2;
import com.ruiwenliu.wrapper.base.presenter.PickerPresenter;
import com.rv.home.rv.module.ApiConfig;
import com.rv.home.rv.module.ui.main.home.order.bean.OrderDetailBean;
import com.rv.home.rv.module.ui.main.home.order.bean.OrderListBean;
import com.yuyife.okgo.OkGoUtil;

import java.util.LinkedHashMap;
import java.util.Map;

import butterknife.BindView;
import butterknife.ButterKnife;
import butterknife.OnClick;

/**
 * 取车二维码
 */
public class PickUpTheCarQRCodeActivity extends BaseStatusActivity<PickerPresenter> {

    @BindView(R2.id.tv_center)
    TextView tvCenter;
    @BindView(R2.id.lay_title)
    RelativeLayout layTitle;
    @BindView(R2.id.iv_goods)
    ImageView ivGoods;
    @BindView(R2.id.tv_car_type)
    TextView tvCarType;
    @BindView(R2.id.tv_get_time)
    TextView tvGetTime;
    @BindView(R2.id.tv_get_address)
    TextView tvGetAddress;
    @BindView(R2.id.ll_get)
    LinearLayout llGet;
    @BindView(R2.id.tv_out_time)
    TextView tvOutTime;
    @BindView(R2.id.tv_out_address)
    TextView tvOutAddress;
    @BindView(R2.id.ll_out)
    LinearLayout llOut;
    @BindView(R2.id.tv_price)
    TextView tvPrice;
    @BindView(R2.id.iv_zxing)
    ImageView ivZxing;

    private OrderDetailBean.DataBeanX dataBean;
    private String no;

    public static Intent getIntent(Context context, String no) {
        return new Intent(context, PickUpTheCarQRCodeActivity.class)
                .putExtra("no", no);
    }

    @Override
    protected int setLayout() {
        return R.layout.activity_pick_up_the_car_qrcode;
    }

    @Override
    protected void loadData(Bundle savedInstanceState, Intent intent) {
        super.loadData(savedInstanceState, intent);
        loadDetailData();
    }

    private void loadDetailData() {
        Map<String, Object> headMap = new LinkedHashMap<>();
        if (OkGoUtil.getToken() != null) {
            headMap.put("Authorization", OkGoUtil.getToken());
            mPresenter.getDataHead(RvFrameConfig.HOST, 1, ApiConfig.HTTP_URL_PRICE_BASEORDER + no, OrderDetailBean.class, headMap, false);
        }
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        showTitle(false);
        no = intent.getStringExtra("no");
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {
        switch (requestType){
            case 1:
                setData((OrderDetailBean)result);
                break;
        }
    }

    private void setData(OrderDetailBean result) {
        dataBean = result.getData();
        if (dataBean != null) {
            if (4 == dataBean.getStatus()) {
                tvCenter.setText("出示取车二维码");
            } else if (5 == dataBean.getStatus()) {
                tvCenter.setText("出示还车二维码");
            }
            tvCarType.setText(dataBean.getName());
            OrderDetailBean.DataBeanX.OrderRentVehicleDetail detail = dataBean.getOrderRentVehicleDetail();
            if (detail != null) {
                tvGetAddress.setText(detail.getStartAddr());
                tvGetTime.setText(TimeManager.stampToDate(String.valueOf(detail.getStartTime())));
                tvOutAddress.setText(detail.getEndAddr());
                tvOutTime.setText(TimeManager.stampToDate(String.valueOf(detail.getEndTime())));
                tvPrice.setText(String.format("¥%1$s", dataBean.getRealAmount()));

                String icon = "";
                if (!TextUtils.isEmpty(dataBean.getCoverPic())) {
                    icon = dataBean.getCoverPic();
                } else {
                    icon = dataBean.getIcon();
                }
                GlideManager.getInstance(mActivity).loadRoundImage(icon, ivGoods,8);
            }
        }
        if (!TextUtils.isEmpty(dataBean.getQrcodeStr())) {
            Bitmap bitmap = ZxingUtils.createQR(dataBean.getQrcodeStr(), DisplayUtil.dip2px(this, 200), DisplayUtil.dip2px(this, 200));
            ivZxing.setImageBitmap(bitmap);
        }
    }


    @OnClick({R2.id.iv_back, R2.id.iv_customer_service})
    public void onViewClicked(View view) {
        int id = view.getId();
        if (id == R.id.iv_back) {
            finish();
        } else if (id == R.id.iv_customer_service) {
            showToast("该功能还在开发中...");
        }
    }
}
