package com.rv.home.rv.module.ui.main.home.order;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.view.ViewPager;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;

import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.frame.base.url.Constance;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseFragment;
import com.ruiwenliu.wrapper.base.BaseStatusActivity;
import com.rv.home.R;
import com.rv.home.R2;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.ruiwenliu.wrapper.weight.horizontal.GallerySnapHelper;
import com.ruiwenliu.wrapper.weight.horizontal.SpaceItemDecoration;
import com.ruiwenliu.wrapper.base.presenter.PickerPresenter;
import com.ruiwenliu.wrapper.adapter.TabAdapter;
import com.rv.home.rv.module.ApiConfig;
import com.rv.home.rv.module.ui.main.home.DrivingUploadActivity;
import com.rv.home.rv.module.ui.main.home.adapter.OrderMenuAdapter;

import java.util.ArrayList;
import java.util.List;

import butterknife.BindView;

@Route(path = Constance.ACTIVITY_URL_ORDERLIST)
public class OrderListActivity extends BaseStatusActivity<PickerPresenter> {

    @BindView(R2.id.recyclerView)
    RecyclerView recyclerView;
    @BindView(R2.id.order_viewPager)
    ViewPager mViewPager;

    private OrderMenuAdapter menuAdapter;
    private TabAdapter mAdapter;
    public final static int TYPE_FOR_PAYMENT = 0;//待付款
    public final static int TYPE_TO_TRAVEL = 1;//待出行
    public final static int TYPE_HAVE_TO_TRAVEL = 2;//已出行
    public final static int TYPE_COMPLETED = 3;//已完成
    public final static int TYPE_ALL_ORDER = 4;//全部
    private int menuPosition;

    public static Intent getIntent(Context context, int position) {
        return new Intent(context, OrderListActivity.class).putExtra("position", position);
    }


    @Override
    protected int setLayout() {
        return R.layout.rv_act_order_list;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        menuPosition = intent.getIntExtra("position", 0);
        titleView.setTitle(mActivity.getString(R.string.rv_my_order));
//        titleView.setText(R.id.tv_title_right, "开发票");
//        titleView.setChildClickListener(R.id.tv_title_right, new View.OnClickListener() {
//            @Override
//            public void onClick(View v) {
//                ARouter.getInstance().build(Constance.ACTIVITY_URL_INVOICINGACTIVITY)
//                        .navigation();
//            }
//        });
        initRecyclerView();
        initViewpager();

    }

    @Override
    protected void loadData(Bundle savedInstanceState, Intent intent) {

    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {

    }


    /**
     * 初始化RecyclerView
     */
    private void initRecyclerView() {
        recyclerView.setLayoutManager(new GridLayoutManager(mActivity, 5));
        menuAdapter = new OrderMenuAdapter();
        recyclerView.setAdapter(menuAdapter);
        recyclerView.addItemDecoration(new SpaceItemDecoration(5));
        GallerySnapHelper snapHelper = new GallerySnapHelper();
        snapHelper.attachToRecyclerView(recyclerView);
        List<String> list = new ArrayList<>();
        list.add(mActivity.getString(R.string.rv_order_for_payment));
        list.add(mActivity.getString(R.string.rv_order_to_travel));
        list.add(mActivity.getString(R.string.rv_order_have_travel));
        list.add(mActivity.getString(R.string.rv_order_completed));
        list.add(mActivity.getString(R.string.rv_order_all_order));
        menuAdapter.setNewData(list);
        menuAdapter.setOnItemClickListener(new BaseQuickAdapter.OnItemClickListener() {
            @Override
            public void onItemClick(BaseQuickAdapter adapter, View view, int position) {
                menuAdapter.setSelectItem(position);
                mViewPager.setCurrentItem(position);
            }
        });
    }

    /**
     * 初始化Viewpager
     */
    private void initViewpager() {
        mAdapter = new TabAdapter(getSupportFragmentManager(), getListFragment());
        mViewPager.setAdapter(mAdapter);
        mViewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener() {
            @Override
            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {

            }

            @Override
            public void onPageSelected(int position) {
                menuAdapter.setSelectItem(position);
            }

            @Override
            public void onPageScrollStateChanged(int state) {

            }
        });
        mViewPager.setOffscreenPageLimit(mAdapter.getCount());
        menuAdapter.setSelectItem(menuPosition);
        mViewPager.setCurrentItem(menuPosition);
    }


    private List<BaseFragment> getListFragment() {
        List<BaseFragment> list = new ArrayList<>();
        list.add(ForPaymentFragment.getInstance(TYPE_FOR_PAYMENT, switchListener));
        list.add(ToTravelFragment.getInstance(TYPE_TO_TRAVEL));
        list.add(HaveToTravelFragment.getInstance(TYPE_HAVE_TO_TRAVEL));
        list.add(CompletedFragment.getInstance(TYPE_COMPLETED));
        list.add(AllOrderFragment.getInstance(TYPE_ALL_ORDER));
        return list;
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        mAdapter.getCurrentFragment().onActivityResult(requestCode, resultCode, data);
    }

    public SwitchListener switchListener = new SwitchListener() {
        @Override
        public void switchTab(int position) {
            if (menuAdapter != null && mViewPager != null) {
                menuAdapter.setSelectItem(position);
                mViewPager.setCurrentItem(position);
            }
        }
    };

    /******
     * 切换事件
     */
    public interface SwitchListener {
        void switchTab(int position);
    }

}
