package com.rv.home.rv.module.ui.main.home.dialog;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.TextView;

import com.ruiwenliu.wrapper.dialog.BaseDialog;
import com.ruiwenliu.wrapper.util.ViewHolder;
import com.rv.home.R;
import com.rv.home.rv.module.ui.main.home.HomeFragment;
import com.rv.home.rv.module.ui.main.home.adapter.CarRentalCheckPriceAdapter;
import com.rv.home.rv.module.ui.main.home.bean.CarRentalPriceBean;

import java.util.ArrayList;
import java.util.List;

/**
 * 查看租车每天价格
 */
public class CheckPriceDialog extends BaseDialog {

    private CarRentalCheckPriceAdapter adapter;

    public CheckPriceDialog(@NonNull Context context) {
        super(context);
        setDialogParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT, Gravity.BOTTOM);
    }


    @Override
    public void helper(ViewHolder helper) {
        super.helper(helper);
        final TextView tvCash = (TextView) helper.getView(R.id.tv_item_use_cash);
        final TextView tvMember = (TextView) helper.getView(R.id.tv_item_use_member);
        final RecyclerView rvContent = (RecyclerView) helper.getView(R.id.rv_content);
        CheckBox isUseMember = (CheckBox) helper.getView(R.id.cb_use_member);
        tvCash.setSelected(true);
        tvCash.setTextColor(getContext().getResources().getColor(R.color.colorWrite));

        adapter = new CarRentalCheckPriceAdapter();
        rvContent.setLayoutManager(new GridLayoutManager(getContext(), 7));
        rvContent.setNestedScrollingEnabled(false);
        rvContent.setAdapter(adapter);
        
        isUseMember.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                if (isChecked) {
                    adapter.setType(true);
                    adapter.notifyDataSetChanged();
                } else {
                    adapter.setType(false);
                    adapter.notifyDataSetChanged();
                }
            }
        });


        helper.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                int id = v.getId();
                if (id == R.id.tv_item_use_cash) {
                    tvCash.setSelected(true);
                    tvCash.setTextColor(getContext().getResources().getColor(R.color.colorWrite));
                    tvMember.setSelected(false);
                    tvMember.setTextColor(getContext().getResources().getColor(R.color.gray_FFB74B));

                } else if (id == R.id.tv_item_use_member) {
                    tvCash.setSelected(false);
                    tvCash.setTextColor(getContext().getResources().getColor(R.color.gray_FFB74B));
                    tvMember.setSelected(true);
                    tvMember.setTextColor(getContext().getResources().getColor(R.color.colorWrite));

                }
            }
        }, R.id.tv_item_use_cash, R.id.tv_item_use_member);
    }


    @Override
    public int getViewLayout() {
        return R.layout.rv_dialog_check_price;
    }

    public void setNewData(List<CarRentalPriceBean.DataBean> data) {
        if (adapter != null && data != null) {
            adapter.setNewData(data);
        }
    }
}
