package com.rv.home.rv.module.ui.main.home.adapter;

import android.content.Intent;
import android.graphics.Color;
import android.graphics.Paint;
import android.net.Uri;
import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;

import com.alibaba.android.arouter.launcher.ARouter;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.frame.base.url.Constance;
import com.rv.component.utils.LocationUtils;
import com.rv.home.R;
import com.rv.home.R2;
import com.rv.home.rv.module.ui.main.home.bean.ShopListBean;

/**
 * Created :Auser
 * Date: 2019/5/18.
 * Desc:选择门店适配器
 */

public class SelectShopAdapter extends BaseQuickAdapter<ShopListBean.DataBeanX.DataBean, BaseViewHolder> {

    private double latitude;
    private double longitude;

    public SelectShopAdapter() {
        super(R.layout.rv_item_select_shop);
    }

    public void setPosition(Double lat, Double lon) {
        this.latitude = lat;
        this.longitude = lon;
    }

    @Override
    protected void convert(BaseViewHolder helper, final ShopListBean.DataBeanX.DataBean item) {
        helper.setText(R.id.tv_name, item.getName());
        helper.setText(R.id.tv_position, "地址: " + item.getAddrDetail());

        helper.setText(R.id.tv_contacts, "联系人: " + item.getLeader());
        TextView tvCall = helper.itemView.findViewById(R.id.tv_call) ;
        tvCall.getPaint().setFlags(Paint.UNDERLINE_TEXT_FLAG); //下划线
        tvCall.getPaint().setAntiAlias(true);//抗锯齿
        tvCall.getPaint().setColor(Color.parseColor("#999999"));
        tvCall.setText(item.getLeaderContactInfo());
        tvCall.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (!TextUtils.isEmpty(item.getLeaderContactInfo())) {
                    Intent t = new Intent();
                    t.setAction(Intent.ACTION_DIAL);
                    t.setData(Uri.parse("tel:" + item.getLeaderContactInfo()));
                    // 通知系统你去帮我干活吧
                    mContext.startActivity(t);
                }
            }
        });

        double distance = LocationUtils.getDistance(latitude, longitude, item.getLatitude(), item.getLongitude());
        int distanceKm = (int) (distance / 1000);
        helper.setText(R.id.tv_distance, "距您" + distanceKm + "km");
        helper.setOnClickListener(R.id.tv_distance, new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                showMap(item);
            }
        });

    }

    private void showMap(ShopListBean.DataBeanX.DataBean bean) {
        if (bean != null) {
            ARouter.getInstance()
                    .build(Constance.ACTIVITY_URL_CARDETAILMAP)
                    .withString("addrDetail", bean.getAddrDetail())
                    .withString("phone", bean.getLeaderContactInfo())
                    .withString("name", bean.getName())
                    .withDouble("latitude", bean.getLatitude())
                    .withDouble("longitude", bean.getLongitude())
                    .navigation();
        }
    }
}