package com.rv.home.rv.module.ui.main.home.adapter;

import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.rv.home.R;
import com.rv.home.rv.module.ui.main.home.bean.OrderCarPriceBean;
import com.rv.home.rv.module.ui.main.home.bean.OrderCarPriceDetailBean;
import com.rv.home.rv.module.ui.main.home.dialog.OrderCarPriceDetailPw;

import java.util.List;

/**
 * 租车订单价格明细
 */

public class OrderCarPriceDetailAdapter extends BaseQuickAdapter<OrderCarPriceDetailBean.ChildrenBean, BaseViewHolder> {
    private OrderDayCarPriceDetailAdapter adapter;
    private boolean type;

    public OrderCarPriceDetailAdapter() {
        super(R.layout.rv_item_order_car_price_detail);
    }

    @Override
    protected void convert(BaseViewHolder helper, OrderCarPriceDetailBean.ChildrenBean item) {

        helper.setText(R.id.tv_name, item.getKey());
        helper.setText(R.id.tv_price, item.getVal());
        if ("优惠券".equals(item.getKey())) {
            helper.setTextColor(R.id.tv_name, helper.itemView.getContext().getResources().getColor(R.color.colorAuxiliaryRed));
            helper.setTextColor(R.id.tv_price, helper.itemView.getContext().getResources().getColor(R.color.colorAuxiliaryRed));
        } else {
            helper.setTextColor(R.id.tv_name, helper.itemView.getContext().getResources().getColor(R.color.textMain));
            helper.setTextColor(R.id.tv_price, helper.itemView.getContext().getResources().getColor(R.color.textMain));
        }
        RecyclerView rvDayPrice = helper.getView(R.id.rv_dayprice);
        rvDayPrice.setLayoutManager(new LinearLayoutManager(helper.itemView.getContext()));
        adapter = new OrderDayCarPriceDetailAdapter();
        rvDayPrice.setAdapter(adapter);

        List<OrderCarPriceBean> dataBean = item.getDataBean();
        if (dataBean != null && dataBean.size() > 0) {
            if (item.isDayPrice()) {
                helper.setText(R.id.tv_attr, item.getDetail());
                helper.setGone(R.id.iv_hint, true);
                adapter.setNewData(dataBean);
                helper.setOnClickListener(R.id.ll_item_isshow_dayprice, new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        if (!type) {
                            rvDayPrice.setVisibility(View.VISIBLE);
                        } else {
                            rvDayPrice.setVisibility(View.GONE);
                        }
                        type = !type;
                    }
                });
            } else {
                helper.setGone(R.id.iv_hint, false);
                double price = dataBean.get(0).getPrice();
                helper.setText(R.id.tv_attr, price + "/天*" + item.getDetail());
            }
        } else {
            helper.setGone(R.id.iv_hint, false);
            helper.setText(R.id.tv_attr, item.getDetail());
        }

        if (!type) {
            rvDayPrice.setVisibility(View.GONE);
        }

    }

    public void setType(boolean b) {
        type = b;
    }
}
