package com.rv.home.rv.module.ui.main.home.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;

import com.rv.home.R;
import com.rv.home.rv.module.ui.main.home.bean.HotCityBean;

import java.util.List;

public class HotCityAdapter extends BaseAdapter {
    private Context mContext;
    private List<HotCityBean> mLists;

    public HotCityAdapter(Context context, List<HotCityBean> lists) {
        this.mContext = context;
        this.mLists = lists;
    }

    @Override
    public int getCount() {
        return mLists.size();
    }

    @Override
    public Object getItem(int position) {
        return mLists.get(position);
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder holder;
        if (convertView == null) {
            convertView = LayoutInflater.from(mContext).inflate(R.layout.rv_item_hot_city, null);
            holder = new ViewHolder();
            holder.tvHotCity = convertView.findViewById(R.id.tv_hot_city);
            convertView.setTag(holder);
        } else {
            holder = (ViewHolder) convertView.getTag();
        }
        holder.tvHotCity.setText(mLists.get(position).hotCityName);
        return convertView;
    }

    private class ViewHolder {
        TextView tvHotCity;
    }
}
