package com.rv.home.rv.module.ui.login;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.Typeface;
import android.support.annotation.NonNull;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.text.style.TextAppearanceSpan;
import android.util.Base64;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.bumptech.glide.Glide;
import com.ruiwenliu.wrapper.dialog.BaseDialog;
import com.ruiwenliu.wrapper.util.glide.GlideOptions;
import com.rv.home.R;
import com.rv.home.rv.module.ui.login.bean.VerifyDataBean;
import com.rv.home.rv.module.ui.login.view.VerifyImageView;
import com.rv.home.rv.until.TransformationUtils;

public class VerifyDialog extends BaseDialog {

    public VerifyDialog(@NonNull Context context) {
        super(context);
    }

    public VerifyDialog(@NonNull Context context, int themeResId) {
        super(context, themeResId);
        setDialogParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT, Gravity.CENTER);
    }

    @Override
    public int getViewLayout() {
        return R.layout.dialog_verfy;
    }

    public static class Builder {

        private Context mContext;
        VerifyImageView verifyView;
        LinearLayout llControl;
        VerifyListener listener;
        TextView tvHint;
        VerifyDataBean.VerifyData verifyData;
        VerifyDialog dialog;

        public Builder(Context context, VerifyDataBean.VerifyData verifyData) {
            this.mContext = context;
            this.verifyData = verifyData;
        }

        public void setListener(VerifyListener listener) {
            this.listener = listener;
        }

        public void change(VerifyDataBean.VerifyData verifyData) {
            this.verifyData = verifyData;
            showPic();
        }

        public void dismiss() {
            if (dialog != null) {
                dialog.dismiss();
            }
        }

        /**
         * 创建定制的对话框
         */
        @SuppressLint("ClickableViewAccessibility")
        public VerifyDialog create() {
            LayoutInflater inflater = (LayoutInflater) mContext.getSystemService(Context.LAYOUT_INFLATER_SERVICE);

            dialog = new VerifyDialog(mContext, R.style.DialogActivityTheme);
            // 获取对话框的布局
            View layout = inflater.inflate(R.layout.dialog_verfy, null);
            // 为对话框添加布局和设置大小
            dialog.addContentView(layout, new WindowManager.LayoutParams(WindowManager.LayoutParams.MATCH_PARENT, WindowManager.LayoutParams.WRAP_CONTENT));

            this.verifyView = layout.findViewById(R.id.verfyview);
            this.verifyView.setVerifyListenter(verifyListenter);
            this.llControl = layout.findViewById(R.id.ll_control);
            this.tvHint = layout.findViewById(R.id.tv_hint);
            showPic();
            layout.findViewById(R.id.ll_change_pic).setOnClickListener(v -> {
                if (listener != null) {
                    listener.freshen();
                }
            });
            layout.findViewById(R.id.tv_cancel).setOnClickListener(v -> {
                if (listener != null) {
                    listener.cancel();
                }
                dialog.dismiss();
            });

            //默认不能点击对话框其他区域退出 和按返回键退出
            dialog.setCancelable(true);
            dialog.setContentView(layout);
            return dialog;
        }

        public void showPic() {

            if (this.tvHint != null && this.verifyData != null && this.verifyData.getWordList() != null && this.verifyData.getWordList().size() > 0) {

                SpannableString spannableString = new SpannableString("请点击图片中的 “" + this.verifyData.getWordList().get(0) + "” 字");
                spannableString.setSpan(new ForegroundColorSpan(Color.parseColor("#f64747")), 9,10, Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
                this.tvHint.setText(spannableString);

            }

            Bitmap bitmap = stringToBitmap(this.verifyData.getOriginalImageBase64());
            GlideOptions options = GlideOptions.placeholderOf(com.ruiwenliu.wrapper.R.drawable.glide_icon_placeholder).
                    error(com.ruiwenliu.wrapper.R.drawable.glide_icon_error);

            Glide.with(mContext)
                    .asBitmap()
                    .load(bitmap)
                    .apply(options)
                    .into(new TransformationUtils(this.verifyView, transforationListener));
        }

        private float sy = 1.0f;

        public VerifyImageView.TouchVerifyListenter verifyListenter = (x, y) -> {
            if (listener != null) {
                float relX = x / sy;
                float relY = y / sy;
                listener.verify((int) relX, (int) relY);
            }
        };

        public Bitmap stringToBitmap(String base64Data) {
            if (TextUtils.isEmpty(base64Data)) return null;

            byte[] bytes = Base64.decode(base64Data, Base64.DEFAULT);
            return BitmapFactory.decodeByteArray(bytes, 0, bytes.length);
        }


        private TransformationUtils.TransforationListener transforationListener = s -> sy = s;
    }


    public interface VerifyListener {

        void cancel();

        void verify(int x, int y);

        void freshen();
    }
}
