package com.rv.camp.camp;

import android.content.Context;
import android.content.Intent;
import android.graphics.Rect;
import android.os.Bundle;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.View;
import android.widget.EditText;

import com.alibaba.android.arouter.launcher.ARouter;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.frame.base.url.Constance;
import com.frame.rv.config.RvFrameConfig;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseStatusActivity;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.rv.camp.CampFragment;
import com.rv.camp.R;
import com.rv.camp.R2;
import com.rv.camp.adapter.CampListAdapter;
import com.rv.camp.api.CampApi;
import com.rv.camp.bean.CampListBean;
import com.rv.camp.presenter.CampPresenter;

import java.util.LinkedHashMap;
import java.util.Map;

import butterknife.BindView;
import butterknife.ButterKnife;
import butterknife.OnClick;

/**
 * 营地搜索
 */
public class CampSearchActivity extends BaseStatusActivity<CampPresenter> implements BaseQuickAdapter.RequestLoadMoreListener {

    @BindView(R2.id.et_search)
    EditText etSearch;
    @BindView(R2.id.rv_content)
    RecyclerView rvContent;

    private CampListAdapter campAdapter;

    private int mPage;
    private int countPage;
    private String content;
    private double latLatitude = 0;
    private double lonLongitude;

    public static Intent getIntent(Context context, double latLatitude, double lonLongitude) {
        return new Intent(context, CampSearchActivity.class)
                .putExtra("latLatitude", latLatitude)
                .putExtra("lonLongitude", lonLongitude);
    }

    @Override
    protected int setLayout() {
        return R.layout.activity_camp_search;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        showTitle(false);

        latLatitude = intent.getDoubleExtra("latLatitude", 0);
        lonLongitude = intent.getDoubleExtra("lonLongitude", 0);

        campAdapter = new CampListAdapter();
        rvContent.setItemAnimator(null);
        rvContent.setLayoutManager(new GridLayoutManager(mActivity, 2));
        rvContent.addItemDecoration(new AbSpacesItemDecoration(20, 10));// 分割线。
//        rvContent.setNestedScrollingEnabled(false);
        rvContent.setAdapter(campAdapter);
        campAdapter.setEmptyView(getEmptyView(rvContent, -1, "还没有营地信息！"));

        campAdapter.setOnItemClickListener(new BaseQuickAdapter.OnItemClickListener() {
            @Override
            public void onItemClick(BaseQuickAdapter adapter, View view, int position) {
                CampListBean.DataBeanX.DataBean data = (CampListBean.DataBeanX.DataBean) adapter.getItem(position);
                ARouter.getInstance()
                        .build(Constance.ACTIVITY_URL_CAMPDETAIL)
                        .withString("id", data.getId())
                        .withDouble("longitude", lonLongitude)
                        .withDouble("latitude", latLatitude)
                        .navigation();
            }
        });

        campAdapter.setOnLoadMoreListener(new BaseQuickAdapter.RequestLoadMoreListener() {
            @Override
            public void onLoadMoreRequested() {
                if (rvContent != null) {
                    rvContent.postDelayed(new Runnable() {
                        @Override
                        public void run() {
                            if (mPage >= countPage) {
                                campAdapter.loadMoreEnd();
                            } else {
                                mPage++;
                                getCampList(mPage, content);
                            }
                        }
                    }, 200);
                }
            }
        }, rvContent);

    }

    /**
     * 刷新数据
     */
    private void loadDataList(String content) {
        mPage = 1;
        getCampList(mPage, content);
    }


    @Override
    public void onShowResult(int requestType, BaseBean result) {
        switch (requestType) {
            case 0:
                processData((CampListBean) result);
                break;
        }
    }


    private void processData(CampListBean bean) {
        if (mPage == 1) {
            if (bean.getData().getTotalCount() == 0) {
                campAdapter.getData().clear();
                campAdapter.notifyDataSetChanged();
                campAdapter.setEmptyView(getEmptyView(rvContent, -1, "还没有营地信息！"));
                return;
            }

            countPage = bean.getData().getTotalPage();
            if (bean.getData().getData() != null) {
                campAdapter.setNewData(bean.getData().getData());
            }
        } else {
            if (bean.getData().getData() != null) {
                campAdapter.addData(bean.getData().getData());
            }
            campAdapter.loadMoreComplete();
        }
    }

    /**
     * 获取营地列表
     */
    private void getCampList(int page, String content) {
        Map<String, Object> map = new LinkedHashMap<>();
        map.put("pageNo", page);
        if (!TextUtils.isEmpty(content)) {
            map.put("keyWord", content);
        }
        mPresenter.getData(RvFrameConfig.VEHICLE_CAMPLIST, 0, CampApi.TRAVEL_CAMPSITESHOP, CampListBean.class, map, page == 1 ? false : false);
    }


    @Override
    public void onLoadMoreRequested() {

    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        // TODO: add setContentView(...) invocation
        ButterKnife.bind(this);
    }

    @OnClick({R2.id.iv_back, R2.id.tv_search})
    public void onViewClicked(View view) {
        int id = view.getId();
        if (id == R.id.iv_back) {
            finish();

        } else if (id == R.id.tv_search) {
            content = etSearch.getText().toString().trim();
            if (TextUtils.isEmpty(content)) {
                showToast("请输入搜索内容！");
                return;
            }
            loadDataList(content);
        }
    }


    public class AbSpacesItemDecoration extends RecyclerView.ItemDecoration {

        private int left;
        private int right;

        public AbSpacesItemDecoration(int left, int right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
            int childCount = parent.getChildCount();
            if ((childCount - 1) % 2 == 0) {
                outRect.left = left;
                outRect.right = right;
                outRect.bottom = right;
                outRect.top = right;
            } else {
                outRect.left = right;
                outRect.right = left;
                outRect.bottom = right;
                outRect.top = right;
            }
        }
    }
}
